/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.join.ArrayPositionLinks;
import io.trino.operator.join.JoinFilterFunction;
import io.trino.operator.join.PositionLinks;
import io.trino.spi.Page;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Objects;

public final class SortedPositionLinks
implements PositionLinks {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SortedPositionLinks.class);
    private final PositionLinks positionLinks;
    private final int[][] sortedPositionLinks;
    private final long sizeInBytes;
    private final JoinFilterFunction[] searchFunctions;

    private SortedPositionLinks(PositionLinks positionLinks, int[][] sortedPositionLinks, List<JoinFilterFunction> searchFunctions) {
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
        this.sortedPositionLinks = Objects.requireNonNull(sortedPositionLinks, "sortedPositionLinks is null");
        this.sizeInBytes = (long)INSTANCE_SIZE + positionLinks.getSizeInBytes() + SortedPositionLinks.sizeOfPositionLinks(sortedPositionLinks);
        Objects.requireNonNull(searchFunctions, "searchFunctions is null");
        Preconditions.checkState((!searchFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Using sortedPositionLinks with no search functions");
        this.searchFunctions = (JoinFilterFunction[])searchFunctions.toArray(JoinFilterFunction[]::new);
    }

    private static long sizeOfPositionLinks(int[][] sortedPositionLinks) {
        long retainedSize = SizeOf.sizeOf((Object[])sortedPositionLinks);
        for (int[] element : sortedPositionLinks) {
            retainedSize += SizeOf.sizeOf((int[])element);
        }
        return retainedSize;
    }

    public static FactoryBuilder builder(int size, PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
        return new FactoryBuilder(size, pagesHashStrategy, addresses);
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static long getEstimatedRetainedSizeInBytes(int positionCount) {
        return (long)INSTANCE_SIZE + ArrayPositionLinks.getEstimatedRetainedSizeInBytes(positionCount) + SizeOf.sizeOfObjectArray((int)positionCount) + SizeOf.sizeOfIntArray((int)positionCount);
    }

    @Override
    public int next(int position, int probePosition, Page allProbeChannelsPage) {
        int nextPosition = this.positionLinks.next(position, probePosition, allProbeChannelsPage);
        if (nextPosition < 0) {
            return -1;
        }
        if (!this.applyAllSearchFunctions(nextPosition, probePosition, allProbeChannelsPage)) {
            return -1;
        }
        return nextPosition;
    }

    @Override
    public int start(int startingPosition, int probePosition, Page allProbeChannelsPage) {
        if (this.applyAllSearchFunctions(startingPosition, probePosition, allProbeChannelsPage)) {
            return startingPosition;
        }
        int[] links = this.sortedPositionLinks[startingPosition];
        if (links == null) {
            return -1;
        }
        int currentStartOffset = 0;
        for (JoinFilterFunction searchFunction : this.searchFunctions) {
            if ((currentStartOffset = SortedPositionLinks.findStartPositionForFunction(searchFunction, links, currentStartOffset, probePosition, allProbeChannelsPage)) != -1) continue;
            return -1;
        }
        return links[currentStartOffset];
    }

    private boolean applyAllSearchFunctions(int buildPosition, int probePosition, Page allProbeChannelsPage) {
        for (JoinFilterFunction searchFunction : this.searchFunctions) {
            if (SortedPositionLinks.applySearchFunction(searchFunction, buildPosition, probePosition, allProbeChannelsPage)) continue;
            return false;
        }
        return true;
    }

    private static int findStartPositionForFunction(JoinFilterFunction searchFunction, int[] links, int startOffset, int probePosition, Page allProbeChannelsPage) {
        if (SortedPositionLinks.applySearchFunction(searchFunction, links, startOffset, probePosition, allProbeChannelsPage)) {
            return startOffset;
        }
        int offset = SortedPositionLinks.lowerBound(searchFunction, links, startOffset, links.length - 1, probePosition, allProbeChannelsPage);
        if (!SortedPositionLinks.applySearchFunction(searchFunction, links, offset, probePosition, allProbeChannelsPage)) {
            return -1;
        }
        return offset;
    }

    private static int lowerBound(JoinFilterFunction searchFunction, int[] links, int first, int last, int probePosition, Page allProbeChannelsPage) {
        int count = last - first;
        while (count > 0) {
            int step = count / 2;
            int middle = first + step;
            if (!SortedPositionLinks.applySearchFunction(searchFunction, links, middle, probePosition, allProbeChannelsPage)) {
                first = ++middle;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    private static boolean applySearchFunction(JoinFilterFunction searchFunction, int[] links, int linkOffset, int probePosition, Page allProbeChannelsPage) {
        return searchFunction.filter(links[linkOffset], probePosition, allProbeChannelsPage);
    }

    private static boolean applySearchFunction(JoinFilterFunction searchFunction, int buildPosition, int probePosition, Page allProbeChannelsPage) {
        return searchFunction.filter(buildPosition, probePosition, allProbeChannelsPage);
    }

    public static class FactoryBuilder
    implements PositionLinks.FactoryBuilder {
        private final Int2ObjectOpenHashMap<IntArrayList> positionLinks;
        private final int size;
        private final PositionComparator comparator;
        private final PagesHashStrategy pagesHashStrategy;
        private final LongArrayList addresses;

        public FactoryBuilder(int size, PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
            this.size = size;
            this.comparator = new PositionComparator(pagesHashStrategy, addresses);
            this.pagesHashStrategy = pagesHashStrategy;
            this.addresses = addresses;
            this.positionLinks = new Int2ObjectOpenHashMap();
        }

        @Override
        public int link(int from, int to) {
            if (this.isNull(from)) {
                return to;
            }
            if (this.isNull(to)) {
                return from;
            }
            if (this.comparator.compare(from, to) > 0) {
                ((IntArrayList)this.positionLinks.computeIfAbsent(to, key -> new IntArrayList())).add(from);
                return to;
            }
            IntArrayList links = (IntArrayList)this.positionLinks.remove(to);
            if (links == null) {
                links = new IntArrayList();
            }
            links.add(to);
            Preconditions.checkState((this.positionLinks.put(from, (Object)links) == null ? 1 : 0) != 0, (Object)"sorted links is corrupted");
            return from;
        }

        private boolean isNull(int position) {
            long pageAddress = this.addresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            return this.pagesHashStrategy.isSortChannelPositionNull(blockIndex, blockPosition);
        }

        @Override
        public PositionLinks.Factory build() {
            ArrayPositionLinks.FactoryBuilder arrayPositionLinksFactoryBuilder = ArrayPositionLinks.builder(this.size);
            int[][] sortedPositionLinks = new int[this.size][];
            ObjectIterator iterator = this.positionLinks.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int key = entry.getIntKey();
                IntArrayList positionsList = (IntArrayList)entry.getValue();
                int[] positions = positionsList.toIntArray();
                sortedPositionLinks[key] = positions;
                if (positions.length <= 0) continue;
                IntArrays.mergeSort((int[])positions, (int)0, (int)positions.length, (IntComparator)this.comparator, (int[])positionsList.elements());
                arrayPositionLinksFactoryBuilder.link(key, positions[0]);
                for (int i = 0; i < positions.length - 1; ++i) {
                    arrayPositionLinksFactoryBuilder.link(positions[i], positions[i + 1]);
                }
            }
            return FactoryBuilder.createFactory(sortedPositionLinks, arrayPositionLinksFactoryBuilder.build());
        }

        @Override
        public boolean isEmpty() {
            return this.positionLinks.isEmpty();
        }

        private static PositionLinks.Factory createFactory(final int[][] sortedPositionLinks, final PositionLinks.Factory arrayPositionLinksFactory) {
            Objects.requireNonNull(sortedPositionLinks, "sortedPositionLinks is null");
            Objects.requireNonNull(arrayPositionLinksFactory, "arrayPositionLinksFactory is null");
            return new PositionLinks.Factory(){

                @Override
                public PositionLinks create(List<JoinFilterFunction> searchFunctions) {
                    return new SortedPositionLinks(arrayPositionLinksFactory.create((List<JoinFilterFunction>)ImmutableList.of()), sortedPositionLinks, searchFunctions);
                }

                @Override
                public long checksum() {
                    return arrayPositionLinksFactory.checksum();
                }
            };
        }
    }

    private static final class PositionComparator
    implements IntComparator {
        private final PagesHashStrategy pagesHashStrategy;
        private final LongArrayList addresses;

        PositionComparator(PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
            this.pagesHashStrategy = pagesHashStrategy;
            this.addresses = addresses;
        }

        public int compare(int leftPosition, int rightPosition) {
            long leftPageAddress = this.addresses.getLong(leftPosition);
            int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
            int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
            long rightPageAddress = this.addresses.getLong(rightPosition);
            int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
            int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
            return this.pagesHashStrategy.compareSortChannelPositions(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
        }
    }
}

