/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QueryDataEncoders {
    private final Map<String, QueryDataEncoder.Factory> factories;

    @Inject
    public QueryDataEncoders(Set<QueryDataEncoder.Factory> factories) {
        this.factories = (Map)Objects.requireNonNull(factories, "factories is null").stream().map(factory -> Map.entry(factory.encoding(), factory)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean exists(String encoding) {
        return this.factories.containsKey(encoding);
    }

    public QueryDataEncoder.Factory get(String encoding) {
        if (!this.exists(encoding)) {
            throw new IllegalArgumentException("Unknown encoding: " + encoding);
        }
        return this.factories.get(encoding);
    }

    public Set<String> getAvailableEncodings() {
        return this.factories.keySet();
    }
}

