/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record Comparison(Operator operator, Expression left, Expression right) implements Expression
{
    public Comparison {
        Objects.requireNonNull(operator, "operator is null");
        IrUtils.validateType(left.type(), right);
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitComparison(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = switch (this.operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "$eq";
            case 1 -> "$ne";
            case 2 -> "$lt";
            case 3 -> "$lte";
            case 4 -> "$gt";
            case 5 -> "$gte";
            case 6 -> "$identical";
        };
        objectArray[1] = this.left;
        objectArray[2] = this.right;
        return "%s(%s, %s)".formatted(objectArray);
    }

    public static enum Operator {
        EQUAL("="),
        NOT_EQUAL("<>"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        IDENTICAL("\u2261");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Operator flip() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EQUAL;
                case 1 -> NOT_EQUAL;
                case 2 -> GREATER_THAN;
                case 3 -> GREATER_THAN_OR_EQUAL;
                case 4 -> LESS_THAN;
                case 5 -> LESS_THAN_OR_EQUAL;
                case 6 -> IDENTICAL;
            };
        }

        public Operator negate() {
            switch (this.ordinal()) {
                case 0: {
                    return NOT_EQUAL;
                }
                case 1: {
                    return EQUAL;
                }
                case 2: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case 3: {
                    return GREATER_THAN;
                }
                case 4: {
                    return LESS_THAN_OR_EQUAL;
                }
                case 5: {
                    return LESS_THAN;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + String.valueOf((Object)this));
        }
    }
}

