/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record In(Expression value, List<Expression> valueList) implements Expression
{
    public In {
        valueList = ImmutableList.copyOf(valueList);
        for (Expression item : valueList) {
            IrUtils.validateType(value.type(), item);
        }
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitIn(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.builder().add((Object)this.value).addAll(this.valueList).build();
    }

    @Override
    public String toString() {
        return "$in(%s, [%s])".formatted(this.value, this.valueList().stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
    }
}

