/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import java.util.List;
import java.util.Objects;

public record CallExpression(ResolvedFunction resolvedFunction, List<RowExpression> arguments) implements RowExpression
{
    @JsonCreator
    public CallExpression {
        Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
        Objects.requireNonNull(arguments, "arguments is null");
        arguments = ImmutableList.copyOf(arguments);
    }

    @Override
    public Type type() {
        return this.resolvedFunction.signature().getReturnType();
    }

    @Override
    public String toString() {
        return String.valueOf(this.resolvedFunction.signature().getName()) + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCall(this, context);
    }
}

