/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestStatsCalculator {
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() {
        this.queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1").build());
        this.queryRunner.installPlugin((Plugin)new TpchPlugin());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testStatsCalculatorUsesLayout() {
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'P'", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(363.0)));
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderkey = 42", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(15000.0)));
    }

    private void assertPlan(String sql, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getPlannerContext().getMetadata(), this.queryRunner.getPlannerContext().getFunctionManager(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }
}

