/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestTopNRankingStatsRule
extends BaseStatsCalculatorTest {
    private final SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.0).build();
    private final SymbolStatsEstimate yStats = SymbolStatsEstimate.builder().setDistinctValuesCount(100.0).setNullsFraction(0.5).build();
    private final SymbolStatsEstimate uStats = SymbolStatsEstimate.builder().setDistinctValuesCount(100.0).setNullsFraction(0.5).build();
    private final SymbolStatsEstimate vStats = SymbolStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.0).build();

    @Test
    public void testRowNumber() {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(50.0).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.distinctValuesCount(5.0)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(10.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)pb.symbol("v", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST, (Object)pb.symbol("v", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 20, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE), pb.symbol("u", (Type)DoubleType.DOUBLE), pb.symbol("v", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "u"), this.uStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "v"), this.vStats).build()).check(check -> check.outputRowsCount(6366.331316).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.isEqualTo(this.yStats)).symbolStats("u", assertion -> assertion.isEqualTo(this.uStats)).symbolStats("v", assertion -> assertion.isEqualTo(this.vStats)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(20.0).distinctValuesCount(20.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
    }

    @Test
    public void testRank() {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.RANK, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(99.009901).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.distinctValuesCount(5.0)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(1.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)pb.symbol("v", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST, (Object)pb.symbol("v", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.RANK, 20, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE), pb.symbol("u", (Type)DoubleType.DOUBLE), pb.symbol("v", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "u"), this.uStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "v"), this.vStats).build()).check(check -> check.outputRowsCount(6366.331316).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.isEqualTo(this.yStats)).symbolStats("u", assertion -> assertion.isEqualTo(this.uStats)).symbolStats("v", assertion -> assertion.isEqualTo(this.vStats)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(20.0).distinctValuesCount(20.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
    }

    @Test
    public void testDenseRank() {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.DENSE_RANK, 3, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(297.029703).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.distinctValuesCount(15.0)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(3.0).distinctValuesCount(3.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)pb.symbol("v", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("u", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST, (Object)pb.symbol("v", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.DENSE_RANK, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE), pb.symbol("u", (Type)DoubleType.DOUBLE), pb.symbol("v", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "u"), this.uStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "v"), this.vStats).build()).check(check -> check.outputRowsCount(3183.165658).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.isEqualTo(this.yStats)).symbolStats("u", assertion -> assertion.isEqualTo(this.uStats)).symbolStats("v", assertion -> assertion.isEqualTo(this.vStats)).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(10.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
    }

    @ParameterizedTest
    @MethodSource(value={"rankTypeWithOutputAndRankSymbolDistinctCount"})
    public void testRowNumberWhenOrderByDistinctCountIsNan(TopNRankingNode.RankingType rankingType, double outputRowCount, double rankSymbolDistinctCount) {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), rankingType, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SymbolStatsEstimate.unknown()).build()).check(check -> check.outputRowsCount(outputRowCount).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())).symbolStats("z", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(rankSymbolDistinctCount).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
    }

    public static Stream<Arguments> rankTypeWithOutputAndRankSymbolDistinctCount() {
        return Stream.of(Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.ROW_NUMBER, 50, 10}), Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.RANK, 10000, 2000}), Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.DENSE_RANK, 10000, 2000}));
    }

    @ParameterizedTest
    @MethodSource(value={"rankTypes"})
    public void testWhenInputRowCountIsNan(TopNRankingNode.RankingType rankingType) {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), rankingType, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(Double.NaN).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), SymbolStatsEstimate.unknown()).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SymbolStatsEstimate.unknown()).build()).check(check -> check.outputRowsCount(Double.NaN).symbolStats("x", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())).symbolStats("y", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())).symbolStats("z", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())));
    }

    @ParameterizedTest
    @MethodSource(value={"rankTypes"})
    public void testWhenPartitionByDistinctCountIsNan(TopNRankingNode.RankingType rankingType) {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), rankingType, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), SymbolStatsEstimate.unknown()).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SymbolStatsEstimate.unknown()).build()).check(check -> check.outputRowsCount(10000.0).symbolStats("x", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())).symbolStats("y", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())).symbolStats("z", assertion -> assertion.isEqualTo(SymbolStatsEstimate.unknown())));
    }

    @ParameterizedTest
    @MethodSource(value={"rankTypes"})
    public void testWhenSourceRowCountIsZero(TopNRankingNode.RankingType rankingType) {
        this.tester().assertStatsFor(pb -> pb.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE), (Object)SortOrder.ASC_NULLS_FIRST)))), rankingType, 10, pb.symbol("z", (Type)DoubleType.DOUBLE), Optional.empty(), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(0.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SymbolStatsEstimate.zero()).build()).check(check -> check.outputRowsCount(0.0).symbolStats("x", assertion -> assertion.isEqualTo(SymbolStatsEstimate.zero())).symbolStats("y", assertion -> assertion.isEqualTo(SymbolStatsEstimate.zero())).symbolStats("z", assertion -> assertion.isEqualTo(SymbolStatsEstimate.zero())));
    }

    public static Stream<Arguments> rankTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.ROW_NUMBER}), Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.RANK}), Arguments.of((Object[])new Object[]{TopNRankingNode.RankingType.DENSE_RANK}));
    }
}

