/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.DefaultWarningCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPlannerWarnings {
    private PlanTester planTester;

    @BeforeAll
    public void setUp() {
        this.planTester = PlanTester.create((Session)TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build());
        this.planTester.createCatalog((String)this.planTester.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterAll
    public void tearDown() {
        this.planTester.close();
        this.planTester = null;
    }

    @Test
    public void testWarning() {
        List<TrinoWarning> warnings = TestPlannerWarnings.createTestWarnings(3);
        List warningCodes = (List)warnings.stream().map(TrinoWarning::getWarningCode).collect(ImmutableList.toImmutableList());
        TestPlannerWarnings.assertPlannerWarnings(this.planTester, "SELECT * FROM NATION", (Map<String, String>)ImmutableMap.of(), warningCodes, Optional.of(ImmutableList.of((Object)new TestWarningsRule(warnings))));
    }

    public static void assertPlannerWarnings(PlanTester planTester, @Language(value="SQL") String sql, Map<String, String> sessionProperties, List<WarningCode> expectedWarnings, Optional<List<Rule<?>>> rules) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(planTester.getDefaultSession().getCatalog()).setSchema(planTester.getDefaultSession().getSchema());
        sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig());
        PlanOptimizersStatsCollector planOptimizersStatsCollector = new PlanOptimizersStatsCollector(5);
        try {
            planTester.inTransaction(sessionBuilder.build(), arg_0 -> TestPlannerWarnings.lambda$assertPlannerWarnings$0(rules, planTester, sql, (WarningCollector)warningCollector, planOptimizersStatsCollector, arg_0));
        }
        catch (TrinoException trinoException) {
            // empty catch block
        }
        Set warnings = (Set)warningCollector.getWarnings().stream().map(TrinoWarning::getWarningCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode expectedWarning : expectedWarnings) {
            if (warnings.contains(expectedWarning)) continue;
            Fail.fail((String)("Expected warning: " + String.valueOf(expectedWarning)));
        }
    }

    public static List<TrinoWarning> createTestWarnings(int numberOfWarnings) {
        Preconditions.checkArgument((numberOfWarnings > 0 ? 1 : 0) != 0, (Object)"numberOfWarnings must be > 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(1, numberOfWarnings).mapToObj(code -> new TrinoWarning(new WarningCode(code, "testWarning"), "Test warning " + code)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static /* synthetic */ Object lambda$assertPlannerWarnings$0(Optional rules, PlanTester planTester, String sql, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector, Session transactionSession) {
        List planOptimizers = rules.isPresent() ? ImmutableList.of((Object)new IterativeOptimizer(planTester.getPlannerContext(), new RuleStatsRecorder(), planTester.getStatsCalculator(), planTester.getCostCalculator(), (Set)ImmutableSet.copyOf((Collection)((Collection)rules.get())))) : planTester.getPlanOptimizers(false);
        planTester.createPlan(transactionSession, sql, planOptimizers, LogicalPlanner.Stage.OPTIMIZED, warningCollector, planOptimizersStatsCollector);
        return null;
    }

    public static class TestWarningsRule
    implements Rule<ProjectNode> {
        private final List<TrinoWarning> warnings;

        public TestWarningsRule(List<TrinoWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            this.warnings.forEach(arg_0 -> ((WarningCollector)context.getWarningCollector()).add(arg_0));
            return Rule.Result.empty();
        }
    }
}

