/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.collect.ImmutableList;
import io.trino.execution.resourcegroups.FifoQueue;
import io.trino.execution.resourcegroups.IndexedPriorityQueue;
import io.trino.execution.resourcegroups.StochasticPriorityQueue;
import io.trino.execution.resourcegroups.UpdateablePriorityQueue;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUpdateablePriorityQueue {
    @Test
    public void testFifoQueue() {
        Assertions.assertThat(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new FifoQueue())).isEqualTo((Object)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testIndexedPriorityQueue() {
        Assertions.assertThat(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue())).isEqualTo((Object)ImmutableList.of((Object)3, (Object)2, (Object)1));
        Assertions.assertThat(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue(IndexedPriorityQueue.PriorityOrdering.HIGH_TO_LOW))).isEqualTo((Object)ImmutableList.of((Object)3, (Object)2, (Object)1));
        Assertions.assertThat(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue(IndexedPriorityQueue.PriorityOrdering.LOW_TO_HIGH))).isEqualTo((Object)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testPrioritizedPeekPollIndexedPriorityQueue() {
        IndexedPriorityQueue queue = new IndexedPriorityQueue();
        queue.addOrUpdate((Object)"a", 1L);
        queue.addOrUpdate((Object)"b", 3L);
        queue.addOrUpdate((Object)"c", 2L);
        Assertions.assertThat((Object)queue.peekPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"b", 3L));
        Assertions.assertThat((Object)queue.pollPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"b", 3L));
        Assertions.assertThat((Object)queue.peekPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"c", 2L));
        Assertions.assertThat((Object)queue.pollPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"c", 2L));
        Assertions.assertThat((Object)queue.peekPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"a", 1L));
        Assertions.assertThat((Object)queue.pollPrioritized()).isEqualTo((Object)new IndexedPriorityQueue.Prioritized((Object)"a", 1L));
        Assertions.assertThat((Object)queue.peekPrioritized()).isNull();
        Assertions.assertThat((Object)queue.pollPrioritized()).isNull();
    }

    @Test
    public void testStochasticPriorityQueue() {
        Assertions.assertThat((TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new StochasticPriorityQueue()).size() == 3 ? 1 : 0) != 0).isTrue();
    }

    private static List<Integer> populateAndExtract(UpdateablePriorityQueue<Integer> queue) {
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        return ImmutableList.copyOf(queue);
    }
}

