/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.scheduler.PartitionedPipelinedOutputBufferManager;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionedPipelinedOutputBufferManager {
    @Test
    public void test() {
        PartitionedPipelinedOutputBufferManager hashOutputBufferManager = new PartitionedPipelinedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 4);
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(0));
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(3));
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(5))).isInstanceOf(IllegalStateException.class)).hasMessage("Unexpected new output buffer 5");
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.noMoreBuffers();
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
    }

    private static void assertOutputBuffers(PipelinedOutputBuffers outputBuffers) {
        Assertions.assertThat((Object)outputBuffers).isNotNull();
        Assertions.assertThat((outputBuffers.getVersion() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)outputBuffers.isNoMoreBufferIds()).isTrue();
        Map buffers = outputBuffers.getBuffers();
        Assertions.assertThat((int)buffers.size()).isEqualTo(4);
        for (int partition = 0; partition < 4; ++partition) {
            Assertions.assertThat((Map)buffers).containsEntry((Object)new PipelinedOutputBuffers.OutputBufferId(partition), (Object)partition);
        }
    }
}

