/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.faulttolerant.BinPackingNodeAllocatorService;
import io.trino.execution.scheduler.faulttolerant.NodeAllocator;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.TaskExecutionClass;
import io.trino.jmh.Benchmarks;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import io.trino.testing.TestingHandles;
import io.trino.testing.assertions.Assert;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBinPackingNodeAllocator {
    private static final int CALLS_COUNT = 100;
    private static final int CATALOGS_COUNT = 20;

    @Benchmark
    @OperationsPerInvocation(value=100)
    public void benchmarkProcessPendingAllocations(BenchmarkData data) {
        BinPackingNodeAllocatorService nodeAllocatorService = data.getNodeAllocatorService();
        for (int i = 0; i < 100; ++i) {
            nodeAllocatorService.processPendingAcquires();
        }
    }

    @Test
    public void ensureBenchmarkValid() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkBinPackingNodeAllocator benchmark = new BenchmarkBinPackingNodeAllocator();
        benchmark.benchmarkProcessPendingAllocations(data);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkBinPackingNodeAllocator.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xmx4g"})).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"64"})
        private int nodeCount;
        @Param(value={"100", "1000", "10000"})
        private int leasesCount = 1000;
        @Param(value={"1", "10", "100"})
        private int requestersCount = 10;
        @Param(value={"false", "true"})
        private boolean preferredNodes;
        @Param(value={"false", "true"})
        private boolean specificCatalogs;
        private BinPackingNodeAllocatorService nodeAllocatorService;

        @Setup
        public void setup() {
            int i;
            ArrayList<InternalNode> nodes = new ArrayList<InternalNode>();
            ConcurrentHashMap<CallSite, Optional<MemoryInfo>> workerMemoryInfos = new ConcurrentHashMap<CallSite, Optional<MemoryInfo>>();
            MemoryInfo memoryInfo = this.buildWorkerMemoryInfo(DataSize.ofBytes((long)0L), (Map<TaskId, DataSize>)ImmutableMap.of());
            for (int i2 = 0; i2 < this.nodeCount; ++i2) {
                String nodeIdentifier = "node" + i2;
                nodes.add(new InternalNode(nodeIdentifier, URI.create("local://127.0.0.1:" + (8000 + i2)), NodeVersion.UNKNOWN, false));
                workerMemoryInfos.put((CallSite)((Object)nodeIdentifier), Optional.of(memoryInfo));
            }
            InMemoryNodeManager nodeManager = new InMemoryNodeManager((Set)ImmutableSet.copyOf(nodes));
            this.nodeAllocatorService = new BinPackingNodeAllocatorService((InternalNodeManager)nodeManager, () -> workerMemoryInfos, false, java.time.Duration.of(1L, ChronoUnit.MINUTES), java.time.Duration.of(1L, ChronoUnit.MINUTES), true, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE), Ticker.systemTicker());
            this.nodeAllocatorService.start();
            NodeAllocator setupNodeAllocator = this.nodeAllocatorService.getNodeAllocator(SessionTestUtils.TEST_SESSION);
            for (int i3 = 0; i3 < this.nodeCount; ++i3) {
                NodeAllocator.NodeLease lease = setupNodeAllocator.acquire(new NodeRequirements(Optional.empty(), Optional.empty(), true), DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
                this.assertAcquired(lease);
            }
            System.out.println("Creating leases");
            ArrayList<NodeAllocator> nodeAllocators = new ArrayList<NodeAllocator>();
            for (i = 0; i < this.requestersCount; ++i) {
                Session session = Session.builder((Session)SessionTestUtils.TEST_SESSION).setQueryId(QueryId.valueOf((String)("query_" + i))).build();
                nodeAllocators.add(this.nodeAllocatorService.getNodeAllocator(session));
            }
            for (i = 0; i < this.leasesCount; ++i) {
                Optional<Object> preferredNode = Optional.empty();
                if (this.preferredNodes) {
                    preferredNode = Optional.of(((InternalNode)nodes.get(i % this.nodeCount)).getHostAndPort());
                }
                Optional<Object> catalog = Optional.empty();
                if (this.specificCatalogs) {
                    catalog = Optional.of(TestingHandles.createTestCatalogHandle((String)("catalog" + i % 20)));
                }
                NodeRequirements requirements = new NodeRequirements(catalog, preferredNode, true);
                NodeAllocator.NodeLease lease = ((NodeAllocator)nodeAllocators.get(i % this.requestersCount)).acquire(requirements, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE), TaskExecutionClass.STANDARD);
                this.assertNotAcquired(lease);
            }
        }

        public BinPackingNodeAllocatorService getNodeAllocatorService() {
            return this.nodeAllocatorService;
        }

        private MemoryInfo buildWorkerMemoryInfo(DataSize usedMemory, Map<TaskId, DataSize> taskMemoryUsage) {
            return new MemoryInfo(4, new MemoryPoolInfo(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), usedMemory.toBytes(), 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)taskMemoryUsage.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((TaskId)entry.getKey()).toString(), entry -> ((DataSize)entry.getValue()).toBytes())), (Map)ImmutableMap.of()));
        }

        private void assertAcquired(NodeAllocator.NodeLease lease) {
            BenchmarkData.assertEventually(() -> {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease not acquired", new Object[0])).isTrue();
            });
        }

        private void assertNotAcquired(NodeAllocator.NodeLease lease) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease acquired", new Object[0])).isFalse();
            this.nodeAllocatorService.processPendingAcquires();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isCancelled()).describedAs("node lease cancelled", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lease.getNode().isDone()).describedAs("node lease acquired", new Object[0])).isFalse();
        }

        private static void assertEventually(Runnable assertion) {
            Assert.assertEventually((Duration)new Duration(1000.0, TimeUnit.MILLISECONDS), (Duration)new Duration(10.0, TimeUnit.MILLISECONDS), assertion::run);
        }
    }
}

