/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import io.trino.likematcher.LikeMatcher;
import io.trino.type.LikePattern;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestLikeMatcher {
    @Test
    public void test() {
        Assertions.assertThat((boolean)TestLikeMatcher.match("__", "a")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("__", "abcdefghi")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("a%", "xyz")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("a%", "a")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("a%", "ab")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("a_", "ab")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%a", "xyz")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%z", "z")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%z", "yz")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_z", "yz")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("abcd", "abcd")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_", "")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_", "a")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_", "ab")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%", "")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%", "a")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%", "ab")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_%", "abcdefg")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_a%", "abcdefg")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_ab_", "xabc")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_ab_", "xyxw")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_a%b_", "xaxxxbx")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("_%_%_%_%", "abcdefghij")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%a%a%a%a%a%a%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%a%a%a%a%a%a%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%a%b%a%b%a%b%", "aabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabb")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%aaaa%bbbb%aaaa%bbbb%aaaa%bbbb%", "aaaabbbbaaaabbbbaaaabbbb")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%aaaaaaaaaaaaaaaaaaaaaaaaaa%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%aab%bba%aab%bba%", "aaaabbbbaaaabbbbaaaa")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%aab%bba%aab%bba%", "aaaabbbbaaaabbbbcccc")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%abaca%", "abababababacabababa")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%bcccccccca%", "bbbbbbbbxax")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%bbxxxxxa%", "bbbxxxxaz")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%aaaaaaxaaaaaa%", "a".repeat(20) + "b".repeat(20) + "a".repeat(20) + "b".repeat(20) + "the quick brown fox jumps over the lazy dog")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%abaaa%", "ababaa")).isFalse();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%paya%", "papaya")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%paya%", "papapaya")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%paya%", "papapapaya")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%paya%", "papapapapaya")).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%paya%", "papapapapapaya")).isTrue();
        LikeMatcher singleOptimized = LikePattern.compile((String)"_", Optional.empty(), (boolean)true).getMatcher();
        LikeMatcher multipleOptimized = LikePattern.compile((String)"_a%b_", Optional.empty(), (boolean)true).getMatcher();
        LikeMatcher single = LikePattern.compile((String)"_", Optional.empty(), (boolean)false).getMatcher();
        LikeMatcher multiple = LikePattern.compile((String)"_a%b_", Optional.empty(), (boolean)false).getMatcher();
        for (int i = 0; i < 0x10FFFF; ++i) {
            Assertions.assertThat((boolean)singleOptimized.match(Character.toString(i).getBytes(StandardCharsets.UTF_8))).isTrue();
            Assertions.assertThat((boolean)single.match(Character.toString(i).getBytes(StandardCharsets.UTF_8))).isTrue();
            String value = "aa" + (char)i + "bb";
            Assertions.assertThat((boolean)multipleOptimized.match(value.getBytes(StandardCharsets.UTF_8))).isTrue();
            Assertions.assertThat((boolean)multiple.match(value.getBytes(StandardCharsets.UTF_8))).isTrue();
        }
    }

    @Test
    @Timeout(value=2L)
    public void testExponentialBehavior() {
        Assertions.assertThat((boolean)TestLikeMatcher.match("%a________________", "xyza1234567890123456")).isTrue();
    }

    @Test
    public void testEscape() {
        Assertions.assertThat((boolean)TestLikeMatcher.match("-%", "%", '-')).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("-_", "_", '-')).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("--", "-", '-')).isTrue();
        Assertions.assertThat((boolean)TestLikeMatcher.match("%$_%", "xxxxx_xxxxx", '$')).isTrue();
    }

    private static boolean match(String pattern, String value) {
        return TestLikeMatcher.match(pattern, value, Optional.empty());
    }

    private static boolean match(String pattern, String value, char escape) {
        return TestLikeMatcher.match(pattern, value, Optional.of(Character.valueOf(escape)));
    }

    private static boolean match(String pattern, String value, Optional<Character> escape) {
        String padding = "++++";
        String padded = padding + value + padding;
        byte[] bytes = padded.getBytes(StandardCharsets.UTF_8);
        boolean optimizedWithoutPadding = LikeMatcher.compile((String)pattern, escape, (boolean)true).match(value.getBytes(StandardCharsets.UTF_8));
        boolean optimizedWithPadding = LikeMatcher.compile((String)pattern, escape, (boolean)true).match(bytes, padding.length(), bytes.length - padding.length() * 2);
        Assertions.assertThat((boolean)optimizedWithPadding).isEqualTo(optimizedWithoutPadding);
        boolean withoutPadding = LikeMatcher.compile((String)pattern, escape, (boolean)false).match(value.getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((boolean)withoutPadding).isEqualTo(optimizedWithoutPadding);
        boolean withPadding = LikeMatcher.compile((String)pattern, escape, (boolean)false).match(bytes, padding.length(), bytes.length - padding.length() * 2);
        Assertions.assertThat((boolean)withPadding).isEqualTo(optimizedWithoutPadding);
        return withPadding;
    }
}

