/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.cache.SafeCaches;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.TestingPagesSerdeFactory;
import io.trino.spi.Page;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class MockExchangeRequestProcessor
implements TestingHttpClient.Processor {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final PagesSerdeFactory serdeFactory = new TestingPagesSerdeFactory();
    private final LoadingCache<URI, MockBuffer> buffers = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder(), (CacheLoader)CacheLoader.from(location -> new MockBuffer((URI)location, this.serdeFactory.createSerializer(Optional.empty()))));
    private final DataSize expectedMaxSize;

    public MockExchangeRequestProcessor(DataSize expectedMaxSize) {
        this.expectedMaxSize = expectedMaxSize;
    }

    public void addPage(URI location, Page page) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).addPage(page);
    }

    public void addPage(URI location, Slice page) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).addPage(page);
    }

    public void setComplete(URI location) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).setCompleted();
    }

    public void setFailed(URI location, RuntimeException failure) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).setFailed(failure);
    }

    public Response handle(Request request) {
        HttpStatus status;
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assertions.assertThat((List)request.getHeaders().get((Object)"X-Trino-Max-Size")).isNotEmpty();
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Trino-Max-Size"));
        Assertions.assertThat((Comparable)maxSize).isEqualTo((Object)this.expectedMaxSize);
        RequestLocation requestLocation = new RequestLocation(request.getUri());
        URI location = requestLocation.getLocation();
        BufferResult result = ((MockBuffer)this.buffers.getUnchecked((Object)location)).getPages(requestLocation.getSequenceId(), maxSize);
        byte[] bytes = new byte[]{};
        if (!result.getSerializedPages().isEmpty()) {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(64);
            sliceOutput.writeInt(-22745087);
            sliceOutput.writeLong(PagesSerdeUtil.calculateChecksum((List)result.getSerializedPages()));
            sliceOutput.writeInt(result.getSerializedPages().size());
            for (Slice page : result.getSerializedPages()) {
                sliceOutput.writeBytes(page);
            }
            bytes = sliceOutput.slice().getBytes();
            status = HttpStatus.OK;
        } else {
            status = HttpStatus.NO_CONTENT;
        }
        return new TestingResponse(status, (ListMultimap)ImmutableListMultimap.builder().put((Object)"Content-Type", (Object)"application/X-trino-pages").put((Object)"X-Trino-Task-Instance-Id", (Object)String.valueOf(result.getTaskInstanceId())).put((Object)"X-Trino-Page-Sequence-Id", (Object)String.valueOf(result.getToken())).put((Object)"X-Trino-Page-End-Sequence-Id", (Object)String.valueOf(result.getNextToken())).put((Object)"X-Trino-Buffer-Complete", (Object)String.valueOf(result.isBufferComplete())).put((Object)"X-Trino-Task-Failed", (Object)"false").build(), bytes);
    }

    private static class MockBuffer {
        private final URI location;
        private final PageSerializer serializer;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final AtomicLong token = new AtomicLong();
        private final BlockingQueue<Slice> serializedPages = new LinkedBlockingQueue<Slice>();
        private final AtomicReference<RuntimeException> failure = new AtomicReference();

        private MockBuffer(URI location, PageSerializer serializer) {
            this.location = location;
            this.serializer = serializer;
        }

        public void setCompleted() {
            this.completed.set(true);
        }

        public synchronized void addPage(Slice page) {
            Preconditions.checkState((this.completed.get() != Boolean.TRUE.booleanValue() ? 1 : 0) != 0, (String)"Location %s is complete", (Object)this.location);
            this.serializedPages.add(page);
        }

        public synchronized void addPage(Page page) {
            Preconditions.checkState((this.completed.get() != Boolean.TRUE.booleanValue() ? 1 : 0) != 0, (String)"Location %s is complete", (Object)this.location);
            this.serializedPages.add(this.serializer.serialize(page));
        }

        public void setFailed(RuntimeException t) {
            this.failure.set(t);
        }

        public BufferResult getPages(long sequenceId, DataSize maxSize) {
            if (this.completed.get() && this.serializedPages.isEmpty()) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)true);
            }
            RuntimeException failure = this.failure.get();
            if (failure != null) {
                throw failure;
            }
            ((AbstractLongAssert)Assertions.assertThat((long)sequenceId).describedAs("token", new Object[0])).isEqualTo(this.token.get());
            Slice serializedPage = null;
            try {
                serializedPage = this.serializedPages.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (serializedPage == null) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)false);
            }
            ArrayList<Slice> responsePages = new ArrayList<Slice>();
            responsePages.add(serializedPage);
            for (long responseSize = (long)serializedPage.length(); responseSize < maxSize.toBytes() && (serializedPage = (Slice)this.serializedPages.poll()) != null; responseSize += (long)serializedPage.length()) {
                responsePages.add(serializedPage);
            }
            long nextToken = this.token.get() + (long)responsePages.size();
            BufferResult bufferResult = new BufferResult(MockExchangeRequestProcessor.TASK_INSTANCE_ID, this.token.get(), nextToken, false, responsePages);
            this.token.set(nextToken);
            return bufferResult;
        }
    }

    private static class RequestLocation {
        private final URI location;
        private final long sequenceId;

        public RequestLocation(URI uri) {
            String string = uri.toString();
            int index = string.lastIndexOf(47);
            this.location = URI.create(string.substring(0, index));
            this.sequenceId = Long.parseLong(string.substring(index + 1));
        }

        public URI getLocation() {
            return this.location;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

