/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Test;

public class TestBitwiseAndAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return LongStream.range(start, start + length).reduce(start, (x, y) -> x & y);
    }

    @Override
    protected String getFunctionName() {
        return "bitwise_and_agg";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BigintType.BIGINT);
    }

    @Test
    public void testNulls() {
        this.testAggregation(1L, new Block[]{BlockAssertions.createLongsBlock(1L, null)});
        this.testAggregation(1L, new Block[]{BlockAssertions.createLongsBlock(null, 1L)});
        this.testAggregation(null, new Block[]{BlockAssertions.createLongsBlock((Iterable<Long>)ImmutableList.of())});
        this.testAggregation(null, new Block[]{BlockAssertions.createLongsBlock(null, null, null)});
    }
}

