/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;

public class TestBooleanAndAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 == 0);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Boolean getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return length > 1 || start % 2 == 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected String getFunctionName() {
        return "bool_and";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BooleanType.BOOLEAN);
    }
}

