/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;

public class TestCountNullAggregation
extends AbstractTestAggregationFunction {
    public TestCountNullAggregation() {
        super((FunctionBundle)InternalFunctionBundle.extractFunctions(CountNull.class));
    }

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return 0L;
    }

    @Override
    protected Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return (long)lengthIncludingNulls - (long)length;
    }

    @Override
    protected String getFunctionName() {
        return "count_null";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BigintType.BIGINT);
    }

    @AggregationFunction(value="count_null")
    public static final class CountNull {
        private CountNull() {
        }

        @InputFunction
        public static void input(@AggregationState NullableLongState state, @BlockPosition @SqlNullable @SqlType(value="bigint") ValueBlock block, @BlockIndex int position) {
            if (block.isNull(position)) {
                state.setValue(state.getValue() + 1L);
            }
            state.setNull(false);
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState scratchState) {
            state.setValue(state.getValue() + scratchState.getValue());
            state.setNull(state.isNull() && scratchState.isNull());
        }

        @OutputFunction(value="bigint")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
            NullableLongState.write((Type)BigintType.BIGINT, (NullableLongState)state, (BlockBuilder)out);
        }
    }
}

