/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.correlation.Covariance;

public class TestDoubleCovariancePopAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 5, start + 5 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "covar_pop";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == 1) {
            return 0.0;
        }
        Covariance covariance = new Covariance();
        return covariance.covariance(AggregationTestUtils.constructDoublePrimitiveArray(start + 5, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length), false);
    }
}

