/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.SqlIntervalYearMonth;
import java.util.List;

public class TestIntervalYearToMonthSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalYearMonthType.INTERVAL_YEAR_MONTH.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlIntervalYearMonth getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            sum += i;
        }
        return new SqlIntervalYearMonth(sum);
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
    }
}

