/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.interval;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExtract {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void tearDown() {
        this.assertions.close();
    }

    @Test
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM INTERVAL '42' YEAR)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM INTERVAL '7' MONTH)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM INTERVAL '20' MONTH)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM INTERVAL '42-07' YEAR TO MONTH)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM INTERVAL '42-20' YEAR TO MONTH)")))).matches("BIGINT '43'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("YEAR(INTERVAL '42' YEAR)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("YEAR(INTERVAL '7' MONTH)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("YEAR(INTERVAL '20' MONTH)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("YEAR(INTERVAL '42-07' YEAR TO MONTH)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("YEAR(INTERVAL '42-20' YEAR TO MONTH)")))).matches("BIGINT '43'");
    }

    @Test
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM INTERVAL '42' YEAR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM INTERVAL '7' MONTH)")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM INTERVAL '42-07' YEAR TO MONTH)")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MONTH(INTERVAL '42' YEAR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MONTH(INTERVAL '7' MONTH)")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MONTH(INTERVAL '42-07' YEAR TO MONTH)")))).matches("BIGINT '7'");
    }

    @Test
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42' DAY)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '12' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '30' HOUR)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '2000' MINUTE)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '99999' SECOND)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12' DAY TO HOUR)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 30' DAY TO HOUR)")))).matches("BIGINT '43'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34' DAY TO MINUTE)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.1' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.12' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.123' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.1234' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.12345' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.123456' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.1234567' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM INTERVAL '42 12:34:56.12345678' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42' DAY)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '12' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '30' HOUR)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '2000' MINUTE)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '99999' SECOND)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12' DAY TO HOUR)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 30' DAY TO HOUR)")))).matches("BIGINT '43'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34' DAY TO MINUTE)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.1' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.12' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.123' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.1234' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.12345' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.123456' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.1234567' DAY TO SECOND)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DAY(INTERVAL '42 12:34:56.12345678' DAY TO SECOND)")))).matches("BIGINT '42'");
    }

    @Test
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '42' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '6' HOUR)")))).matches("BIGINT '6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '28' HOUR)")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '60' MINUTE)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '180' MINUTE)")))).matches("BIGINT '3'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '60' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '42' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '6' HOUR)")))).matches("BIGINT '6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '28' HOUR)")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '60' MINUTE)")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '180' MINUTE)")))).matches("BIGINT '3'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '60' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("HOUR(INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '0'");
    }

    @Test
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '1' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '6' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '28' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '42' MINUTE)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '182' MINUTE)")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '10' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '120' SECOND)")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '1' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '6' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '28' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '42' MINUTE)")))).matches("BIGINT '42'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '182' MINUTE)")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '10' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '120' SECOND)")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MINUTE(INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '34'");
    }

    @Test
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '1' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '6' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '28' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '42' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '182' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '10' SECOND)")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '120' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '1 12:34:56.1' DAY TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '1' DAY)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '6' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '28' HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '42' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '182' MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '10' SECOND)")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '120' SECOND)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '1 12' DAY TO HOUR)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '1 12:34' DAY TO MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '1 12:34:56' DAY TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '1 12:34:56.1' DAY TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '12:34' HOUR TO MINUTE)")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '12:34:56' HOUR TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.1' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.12' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.123' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.1234' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.12345' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.123456' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.1234567' MINUTE TO SECOND)")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SECOND(INTERVAL '34:56.12345678' MINUTE TO SECOND)")))).matches("BIGINT '56'");
    }
}

