/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.inject.CreationException;
import io.airlift.configuration.secrets.SecretsResolver;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.client.NodeVersion;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.SecurityContext;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.io.File;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.junit.jupiter.api.Test;

public class TestFileBasedSystemAccessControl {
    private static final Identity alice = Identity.forUser((String)"alice").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity kerberosValidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("alice/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidNonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withPrincipal((Principal)new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInvalidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("valid/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexWildDot = Identity.forUser((String)".*").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexEndQuote = Identity.forUser((String)"\\E").withPrincipal((Principal)new KerberosPrincipal("special/\\E@EXAMPLE.COM")).build();
    private static final Identity invalidSpecialRegex = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity bob = Identity.forUser((String)"bob").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity admin = Identity.forUser((String)"alberto").withEnabledRoles((Set)ImmutableSet.of((Object)"admin")).build();
    private static final Identity nonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withGroups((Set)ImmutableSet.of((Object)"\u0194\u0194\u0194")).build();
    private static final Set<String> allCatalogs = ImmutableSet.of((Object)"secret", (Object)"open-to-all", (Object)"all-allowed", (Object)"alice-catalog", (Object)"\u0200\u0200\u0200", (Object)"staff-catalog", (Object[])new String[0]);
    private static final QualifiedObjectName aliceTable = new QualifiedObjectName("alice-catalog", "schema", "table");
    private static final QualifiedObjectName aliceView = new QualifiedObjectName("alice-catalog", "schema", "view");
    private static final QualifiedObjectName aliceMaterializedView = new QualifiedObjectName("alice-catalog", "schema", "materialized-view");
    private static final CatalogSchemaName aliceSchema = new CatalogSchemaName("alice-catalog", "schema");
    private static final QualifiedObjectName staffTable = new QualifiedObjectName("staff-catalog", "schema2", "table");
    private static final QualifiedObjectName staffView = new QualifiedObjectName("staff-catalog", "schema2", "view");
    private static final QualifiedObjectName staffMaterializedView = new QualifiedObjectName("staff-catalog", "schema2", "materialized-view");
    private static final QueryId queryId = new QueryId("query_id");
    private static final Instant queryStart = Instant.now();

    @Test
    public void testCanImpersonateUserOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_impersonation.json");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "bob");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "charlie");
        try {
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "admin");
            throw new AssertionError((Object)"expected AccessDeniedException");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "alice");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "bob");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "anything");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin-other"), "anything");
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin-test"), "alice")).isInstanceOf(AccessDeniedException.class);
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"invalid"), "alice")).isInstanceOf(AccessDeniedException.class);
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"anything"), "test");
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"invalid-other"), "test")).isInstanceOf(AccessDeniedException.class);
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"svc_tenant"), "svc_tenant_prod");
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"svc_tenant"), "svc_tenant_other")).isInstanceOf(AccessDeniedException.class);
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"svc_tenant"), "svc_other_prod")).isInstanceOf(AccessDeniedException.class);
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"external_corp_dept"), "internal-dept-corp-sandbox");
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"external_corp_dept"), "internal-corp-dept-sandbox")).isInstanceOf(AccessDeniedException.class);
            Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"external_corp_dept"), "invalid")).isInstanceOf(AccessDeniedException.class);
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"missing_replacement_group"), "anything");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"incorrect_number_of_replacements_groups_group"), "$2_group_prod")).isInstanceOf(TrinoException.class)).hasMessageContaining("new_user in impersonation rule refers to a capturing group that does not exist in original_user");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"incorrect_number_of_replacements_groups_group"), "group_group_prod")).isInstanceOf(TrinoException.class)).hasMessageContaining("new_user in impersonation rule refers to a capturing group that does not exist in original_user");
            AccessControlManager accessControlManagerWithPrincipal = this.newAccessControlManager(transactionManager, "catalog_principal.json");
            accessControlManagerWithPrincipal.checkCanImpersonateUser(Identity.ofUser((String)"anything"), "anythingElse");
            return;
        }
    }

    @Test
    public void testDocsExample() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
        accessControlManager.loadSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)new File("../../docs/src/main/sphinx/security/user-impersonation.json").getAbsolutePath()));
        accessControlManager.checkCanImpersonateUser(admin, "charlie");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(admin, "bob")).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Access Denied: User alberto cannot impersonate user bob");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"charlie"), "doris")).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Access Denied: User charlie cannot impersonate user doris");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"charlie"), "test");
    }

    @Test
    public void testCanSetUserOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_principal.json");
        Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetUser(Optional.empty(), alice.getUser())).isInstanceOf(AccessDeniedException.class);
        accessControlManager.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
        accessControlManager.checkCanSetUser(kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
        Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetUser(kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser())).isInstanceOf(AccessDeniedException.class);
        accessControlManager.checkCanSetUser(kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
        Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetUser(kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser())).isInstanceOf(AccessDeniedException.class);
        accessControlManager.checkCanSetUser(validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
        accessControlManager.checkCanSetUser(validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
        Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetUser(invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser())).isInstanceOf(AccessDeniedException.class);
        AccessControlManager accessControlManagerNoPatterns = this.newAccessControlManager(transactionManager, "catalog.json");
        accessControlManagerNoPatterns.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
    }

    @Test
    public void testSystemInformation() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "system_information.json");
        accessControlManager.checkCanReadSystemInformation(admin);
        accessControlManager.checkCanWriteSystemInformation(admin);
        accessControlManager.checkCanReadSystemInformation(nonAsciiUser);
        accessControlManager.checkCanWriteSystemInformation(nonAsciiUser);
        accessControlManager.checkCanReadSystemInformation(admin);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSystemInformation$16(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot write system information");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSystemInformation$18(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot read system information");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSystemInformation$20(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot write system information");
    }

    @Test
    public void testCatalogOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, admin, queryId, queryStart), allCatalogs)).isEqualTo(allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed", (Object)"staff-catalog");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, alice, queryId, queryStart), allCatalogs)).isEqualTo((Object)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"staff-catalog");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, bob, queryId, queryStart), allCatalogs)).isEqualTo((Object)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, nonAsciiUser, queryId, queryStart), allCatalogs)).isEqualTo((Object)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testCatalogOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, admin, queryId, queryStart), allCatalogs)).isEqualTo(allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, alice, queryId, queryStart), allCatalogs)).isEqualTo((Object)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, bob, queryId, queryStart), allCatalogs)).isEqualTo((Object)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assertions.assertThat((Collection)accessControlManager.filterCatalogs(new SecurityContext(transactionId, nonAsciiUser, queryId, queryStart), allCatalogs)).isEqualTo((Object)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testSchemaOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assertions.assertThat((Collection)accessControlManager.filterSchemas(new SecurityContext(transactionId, alice, queryId, queryStart), "alice-catalog", (Set)aliceSchemas)).isEqualTo((Object)aliceSchemas);
            Assertions.assertThat((Collection)accessControlManager.filterSchemas(new SecurityContext(transactionId, bob, queryId, queryStart), "alice-catalog", (Set)aliceSchemas)).isEqualTo((Object)ImmutableSet.of());
            accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema, (Map)ImmutableMap.of());
            accessControlManager.checkCanDropSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema);
            accessControlManager.checkCanRenameSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema, "new-schema");
            accessControlManager.checkCanShowSchemas(new SecurityContext(transactionId, alice, queryId, queryStart), "alice-catalog");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSchemaOperations$25(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testSchemaOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assertions.assertThat((Collection)accessControlManager.filterSchemas(new SecurityContext(transactionId, alice, queryId, queryStart), "alice-catalog", (Set)aliceSchemas)).isEqualTo((Object)aliceSchemas);
            Assertions.assertThat((Collection)accessControlManager.filterSchemas(new SecurityContext(transactionId, bob, queryId, queryStart), "alice-catalog", (Set)aliceSchemas)).isEqualTo((Object)ImmutableSet.of());
            accessControlManager.checkCanShowSchemas(new SecurityContext(transactionId, alice, queryId, queryStart), "alice-catalog");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSchemaOperationsReadOnly$28(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create schema alice-catalog.schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSchemaOperationsReadOnly$30(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop schema alice-catalog.schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSchemaOperationsReadOnly$32(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot rename schema from alice-catalog.schema to new-schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testSchemaOperationsReadOnly$34(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testTableOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            SecurityContext aliceContext = new SecurityContext(transactionId, alice, queryId, queryStart);
            SecurityContext bobContext = new SecurityContext(transactionId, bob, queryId, queryStart);
            SecurityContext nonAsciiContext = new SecurityContext(transactionId, nonAsciiUser, queryId, queryStart);
            Assertions.assertThat((Collection)accessControlManager.filterTables(aliceContext, "alice-catalog", (Set)aliceTables)).isEqualTo((Object)aliceTables);
            Assertions.assertThat((Collection)accessControlManager.filterTables(aliceContext, "staff-catalog", (Set)aliceTables)).isEqualTo((Object)aliceTables);
            Assertions.assertThat((Collection)accessControlManager.filterTables(bobContext, "alice-catalog", (Set)aliceTables)).isEqualTo((Object)ImmutableSet.of());
            Assertions.assertThat((Collection)accessControlManager.filterTables(bobContext, "staff-catalog", (Set)aliceTables)).isEqualTo((Object)aliceTables);
            Assertions.assertThat((Collection)accessControlManager.filterTables(nonAsciiContext, "alice-catalog", (Set)aliceTables)).isEqualTo((Object)ImmutableSet.of());
            Assertions.assertThat((Collection)accessControlManager.filterTables(nonAsciiContext, "staff-catalog", (Set)aliceTables)).isEqualTo((Object)ImmutableSet.of());
            accessControlManager.checkCanCreateTable(aliceContext, aliceTable, Map.of());
            accessControlManager.checkCanDropTable(aliceContext, aliceTable);
            accessControlManager.checkCanTruncateTable(aliceContext, aliceTable);
            accessControlManager.checkCanSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(aliceContext, aliceTable);
            accessControlManager.checkCanDeleteFromTable(aliceContext, aliceTable);
            accessControlManager.checkCanSetTableProperties(aliceContext, aliceTable, (Map)ImmutableMap.of());
            accessControlManager.checkCanAddColumns(aliceContext, aliceTable);
            accessControlManager.checkCanRenameColumn(aliceContext, aliceTable);
            accessControlManager.checkCanCreateTable(aliceContext, staffTable, Map.of());
            accessControlManager.checkCanDropTable(aliceContext, staffTable);
            accessControlManager.checkCanTruncateTable(aliceContext, staffTable);
            accessControlManager.checkCanSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(aliceContext, staffTable);
            accessControlManager.checkCanDeleteFromTable(aliceContext, staffTable);
            accessControlManager.checkCanSetTableProperties(aliceContext, staffTable, (Map)ImmutableMap.of());
            accessControlManager.checkCanAddColumns(aliceContext, staffTable);
            accessControlManager.checkCanRenameColumn(aliceContext, staffTable);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(bobContext, aliceTable, Map.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanTruncateTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetTableProperties(bobContext, aliceTable, (Map)ImmutableMap.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            accessControlManager.checkCanCreateTable(bobContext, staffTable, Map.of());
            accessControlManager.checkCanDropTable(bobContext, staffTable);
            accessControlManager.checkCanTruncateTable(bobContext, staffTable);
            accessControlManager.checkCanSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(bobContext, staffTable);
            accessControlManager.checkCanDeleteFromTable(bobContext, staffTable);
            accessControlManager.checkCanSetTableProperties(bobContext, staffTable, (Map)ImmutableMap.of());
            accessControlManager.checkCanAddColumns(bobContext, staffTable);
            accessControlManager.checkCanRenameColumn(bobContext, staffTable);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(nonAsciiContext, aliceTable, Map.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanTruncateTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetTableProperties(nonAsciiContext, aliceTable, (Map)ImmutableMap.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(nonAsciiContext, staffTable, Map.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanTruncateTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetTableProperties(nonAsciiContext, staffTable, (Map)ImmutableMap.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
        });
    }

    @Test
    public void testTableOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assertions.assertThat((Collection)accessControlManager.filterTables(new SecurityContext(transactionId, alice, queryId, queryStart), "alice-catalog", (Set)aliceTables)).isEqualTo((Object)aliceTables);
            Assertions.assertThat((Collection)accessControlManager.filterTables(new SecurityContext(transactionId, bob, queryId, queryStart), "alice-catalog", (Set)aliceTables)).isEqualTo((Object)ImmutableSet.of());
            accessControlManager.checkCanSelectFromColumns(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable, (Set)ImmutableSet.of());
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$68(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$70(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$72(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot truncate table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$74(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$76(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot delete from table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$78(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot set table properties to alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$80(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot add a column to table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$82(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot rename a column in table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testTableOperationsReadOnly$84(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testViewOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext aliceContext = new SecurityContext(transactionId, alice, queryId, queryStart);
            SecurityContext bobContext = new SecurityContext(transactionId, bob, queryId, queryStart);
            SecurityContext nonAsciiContext = new SecurityContext(transactionId, nonAsciiUser, queryId, queryStart);
            accessControlManager.checkCanCreateView(aliceContext, aliceView);
            accessControlManager.checkCanDropView(aliceContext, aliceView);
            accessControlManager.checkCanSelectFromColumns(aliceContext, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(aliceContext, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(aliceContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(aliceContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true);
            accessControlManager.checkCanCreateView(aliceContext, staffView);
            accessControlManager.checkCanDropView(aliceContext, staffView);
            accessControlManager.checkCanSelectFromColumns(aliceContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(aliceContext, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(aliceContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(aliceContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(bobContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(bobContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(bobContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(bobContext, "alice-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(bobContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(bobContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            accessControlManager.checkCanCreateView(bobContext, staffView);
            accessControlManager.checkCanDropView(bobContext, staffView);
            accessControlManager.checkCanSelectFromColumns(bobContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(bobContext, "staff-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(bobContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(bobContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(nonAsciiContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(nonAsciiContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(nonAsciiContext, "alice-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(nonAsciiContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(nonAsciiContext, Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(nonAsciiContext, staffView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(nonAsciiContext, staffView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, staffView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(nonAsciiContext, "staff-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(nonAsciiContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(nonAsciiContext, Privilege.SELECT, staffTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
        });
    }

    @Test
    public void testViewOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext context = new SecurityContext(transactionId, alice, queryId, queryStart);
            accessControlManager.checkCanSelectFromColumns(context, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(context, "alice-catalog", "property");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testViewOperationsReadOnly$112(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create view alice-catalog.schema.view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testViewOperationsReadOnly$114(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop view alice-catalog.schema.view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testViewOperationsReadOnly$116(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot grant privilege SELECT on table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testViewOperationsReadOnly$118(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot revoke privilege SELECT on table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testViewOperationsReadOnly$120(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testMaterializedViewAccess() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext aliceContext = new SecurityContext(transactionId, alice, queryId, queryStart);
            SecurityContext bobContext = new SecurityContext(transactionId, bob, queryId, queryStart);
            SecurityContext nonAsciiContext = new SecurityContext(transactionId, nonAsciiUser, queryId, queryStart);
            accessControlManager.checkCanCreateMaterializedView(aliceContext, aliceMaterializedView, Map.of());
            accessControlManager.checkCanDropMaterializedView(aliceContext, aliceMaterializedView);
            accessControlManager.checkCanRefreshMaterializedView(aliceContext, aliceMaterializedView);
            accessControlManager.checkCanSetMaterializedViewProperties(aliceContext, aliceMaterializedView, (Map)ImmutableMap.of());
            accessControlManager.checkCanCreateMaterializedView(aliceContext, staffMaterializedView, Map.of());
            accessControlManager.checkCanDropMaterializedView(aliceContext, staffMaterializedView);
            accessControlManager.checkCanRefreshMaterializedView(aliceContext, staffMaterializedView);
            accessControlManager.checkCanSetMaterializedViewProperties(aliceContext, staffMaterializedView, (Map)ImmutableMap.of());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateMaterializedView(bobContext, aliceMaterializedView, Map.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropMaterializedView(bobContext, aliceMaterializedView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRefreshMaterializedView(bobContext, aliceMaterializedView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetMaterializedViewProperties(bobContext, aliceMaterializedView, (Map)ImmutableMap.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            accessControlManager.checkCanCreateMaterializedView(bobContext, staffMaterializedView, Map.of());
            accessControlManager.checkCanDropMaterializedView(bobContext, staffMaterializedView);
            accessControlManager.checkCanRefreshMaterializedView(bobContext, staffMaterializedView);
            accessControlManager.checkCanSetMaterializedViewProperties(bobContext, staffMaterializedView, (Map)ImmutableMap.of());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateMaterializedView(nonAsciiContext, aliceMaterializedView, Map.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropMaterializedView(nonAsciiContext, aliceMaterializedView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRefreshMaterializedView(nonAsciiContext, aliceMaterializedView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetMaterializedViewProperties(nonAsciiContext, aliceMaterializedView, (Map)ImmutableMap.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
        });
    }

    @Test
    public void testReadOnlyMaterializedViewAccess() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext context = new SecurityContext(transactionId, alice, queryId, queryStart);
            accessControlManager.checkCanSelectFromColumns(context, aliceMaterializedView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(context, "alice-catalog", "property");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$132(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create materialized view alice-catalog.schema.materialized-view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$134(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop materialized view alice-catalog.schema.materialized-view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$136(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot refresh materialized view alice-catalog.schema.materialized-view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$138(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot set properties of materialized view alice-catalog.schema.materialized-view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$140(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$142(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testReadOnlyMaterializedViewAccess$144(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testRefreshing() throws Exception {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        accessControlManager.loadSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)configFile.getAbsolutePath(), (Object)"security.refresh-period", (Object)"1ms"));
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView);
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView);
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView);
        });
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("security-config-file-with-unknown-rules.json")), (File)configFile);
        Thread.sleep(2L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testRefreshing$147(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(UncheckedIOException.class)).hasMessageStartingWith("Failed to convert JSON tree node");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedSystemAccessControl.lambda$testRefreshing$149(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(UncheckedIOException.class)).hasMessageStartingWith("Failed to convert JSON tree node");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        Thread.sleep(2L);
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView));
    }

    @Test
    public void testAllowModeIsRequired() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_allow_unset.json")).isInstanceOf(CreationException.class)).hasMessageContaining("Failed to convert JSON tree node");
    }

    @Test
    public void testAllowModeInvalidValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_invalid_allow_value.json")).isInstanceOf(CreationException.class)).hasMessageContaining("Failed to convert JSON tree node");
    }

    private AccessControlManager newAccessControlManager(TransactionManager transactionManager, String resourceName) {
        AccessControlManager accessControlManager = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
        accessControlManager.loadSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)this.getResourcePath(resourceName)));
        return accessControlManager;
    }

    private String getResourcePath(String resourceName) {
        try {
            return new File(Resources.getResource((String)resourceName).toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void parseUnknownRules() {
        Assertions.assertThatThrownBy(() -> this.parse(this.getResourcePath("security-config-file-with-unknown-rules.json"))).hasMessageContaining("Failed to convert JSON tree node");
    }

    private void parse(String path) {
        new FileBasedSystemAccessControl.Factory().create((Map)ImmutableMap.of((Object)"security.config-file", (Object)path));
    }

    private static /* synthetic */ void lambda$testRefreshing$149(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView));
    }

    private static /* synthetic */ void lambda$testRefreshing$147(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$144(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSetMaterializedViewProperties(new SecurityContext(transactionId, bob, queryId, queryStart), aliceMaterializedView, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$142(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRefreshMaterializedView(new SecurityContext(transactionId, bob, queryId, queryStart), aliceMaterializedView));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$140(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateMaterializedView(new SecurityContext(transactionId, bob, queryId, queryStart), aliceMaterializedView, Map.of()));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$138(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSetMaterializedViewProperties(new SecurityContext(transactionId, alice, queryId, queryStart), aliceMaterializedView, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$136(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRefreshMaterializedView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceMaterializedView));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$134(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropMaterializedView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceMaterializedView));
    }

    private static /* synthetic */ void lambda$testReadOnlyMaterializedViewAccess$132(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateMaterializedView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceMaterializedView, Map.of()));
    }

    private static /* synthetic */ void lambda$testViewOperationsReadOnly$120(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, bob, queryId, queryStart), aliceView));
    }

    private static /* synthetic */ void lambda$testViewOperationsReadOnly$118(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRevokeTablePrivilege(new SecurityContext(transactionId, alice, queryId, queryStart), Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "revokee"), true));
    }

    private static /* synthetic */ void lambda$testViewOperationsReadOnly$116(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanGrantTablePrivilege(new SecurityContext(transactionId, alice, queryId, queryStart), Privilege.SELECT, aliceTable, new TrinoPrincipal(PrincipalType.USER, "grantee"), true));
    }

    private static /* synthetic */ void lambda$testViewOperationsReadOnly$114(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView));
    }

    private static /* synthetic */ void lambda$testViewOperationsReadOnly$112(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId, queryStart), aliceView));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$84(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(new SecurityContext(transactionId, bob, queryId, queryStart), aliceTable, Map.of()));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$82(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameColumn(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$80(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanAddColumns(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$78(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSetTableProperties(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$76(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDeleteFromTable(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$74(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$72(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanTruncateTable(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$70(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropTable(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable));
    }

    private static /* synthetic */ void lambda$testTableOperationsReadOnly$68(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(new SecurityContext(transactionId, alice, queryId, queryStart), aliceTable, Map.of()));
    }

    private static /* synthetic */ void lambda$testSchemaOperationsReadOnly$34(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, bob, queryId, queryStart), aliceSchema, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testSchemaOperationsReadOnly$32(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema, "new-schema"));
    }

    private static /* synthetic */ void lambda$testSchemaOperationsReadOnly$30(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema));
    }

    private static /* synthetic */ void lambda$testSchemaOperationsReadOnly$28(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, alice, queryId, queryStart), aliceSchema, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testSchemaOperations$25(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, bob, queryId, queryStart), aliceSchema, (Map)ImmutableMap.of()));
    }

    private static /* synthetic */ void lambda$testSystemInformation$20(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanWriteSystemInformation(bob));
    }

    private static /* synthetic */ void lambda$testSystemInformation$18(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanReadSystemInformation(bob));
    }

    private static /* synthetic */ void lambda$testSystemInformation$16(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanWriteSystemInformation(alice));
    }
}

