/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.trino.FullConnectorSession;
import io.trino.block.BlockAssertions;
import io.trino.operator.project.InputChannels;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.DictionaryAwareColumnarFilter;
import io.trino.testing.TestingSession;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestDictionaryAwareColumnarFilter {
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));

    @Test
    public void testGetInputChannels() {
        DictionaryAwareColumnarFilter filter = new DictionaryAwareColumnarFilter(new ColumnarFilter(this){

            public int filterPositionsRange(ConnectorSession session, int[] outputPositions, int offset, int size, Page loadedPage) {
                throw new UnsupportedOperationException();
            }

            public int filterPositionsList(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, Page loadedPage) {
                throw new UnsupportedOperationException();
            }

            public InputChannels getInputChannels() {
                return new InputChannels(new int[]{3});
            }
        });
        Assertions.assertThat((List)filter.getInputChannels().getInputChannels()).isEqualTo((Object)ImmutableList.of((Object)3));
    }

    @Test
    public void testSimpleBlock() {
        ValueBlock block = BlockAssertions.createLongSequenceBlock(0, 100);
        TestDictionaryAwareColumnarFilter.testFilter((Block)block, LongArrayBlock.class);
    }

    @ParameterizedTest
    @MethodSource(value={"io.trino.testing.DataProviders#trueFalse"})
    public void testRleBlock(boolean usePositionsList) {
        TestDictionaryAwareColumnarFilter.testRleBlock(true, usePositionsList);
        TestDictionaryAwareColumnarFilter.testRleBlock(false, usePositionsList);
    }

    private static void testRleBlock(boolean filterRange, boolean usePositionsList) {
        DictionaryAwareColumnarFilter filter = TestDictionaryAwareColumnarFilter.createDictionaryAwareColumnarFilter(filterRange, LongArrayBlock.class);
        RunLengthEncodedBlock match = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(4, 5), (int)100);
        TestDictionaryAwareColumnarFilter.testFilter(filter, (Block)match, filterRange, usePositionsList);
        RunLengthEncodedBlock noMatch = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(0, 1), (int)100);
        TestDictionaryAwareColumnarFilter.testFilter(filter, (Block)noMatch, filterRange, usePositionsList);
    }

    @ParameterizedTest
    @MethodSource(value={"io.trino.testing.DataProviders#trueFalse"})
    public void testRleBlockWithFailure(boolean usePositionsList) {
        DictionaryAwareColumnarFilter filter = TestDictionaryAwareColumnarFilter.createDictionaryAwareColumnarFilter(true, LongArrayBlock.class);
        RunLengthEncodedBlock fail = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(-10, -9), (int)100);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwareColumnarFilter.testFilter(filter, (Block)fail, true, usePositionsList)).isInstanceOf(NegativeValueException.class)).hasMessage("value is negative: -10");
    }

    @Test
    public void testDictionaryBlock() {
        TestDictionaryAwareColumnarFilter.testFilter(TestDictionaryAwareColumnarFilter.createDictionaryBlock(20, 100), LongArrayBlock.class);
        TestDictionaryAwareColumnarFilter.testFilter(TestDictionaryAwareColumnarFilter.createDictionaryBlock(20, 0), LongArrayBlock.class);
        TestDictionaryAwareColumnarFilter.testFilter(DictionaryBlock.create((int)100, (Block)BlockAssertions.createLongSequenceBlock(4, 5), (int[])new int[100]), LongArrayBlock.class);
    }

    @Test
    public void testDictionaryBlockWithFailure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwareColumnarFilter.testFilter(TestDictionaryAwareColumnarFilter.createDictionaryBlockWithFailure(20, 100), LongArrayBlock.class)).isInstanceOf(NegativeValueException.class)).hasMessage("value is negative: -10");
    }

    @Test
    public void testDictionaryBlockProcessingWithUnusedFailure() {
        TestDictionaryAwareColumnarFilter.testFilter(TestDictionaryAwareColumnarFilter.createDictionaryBlockWithUnusedEntries(20, 100), DictionaryBlock.class);
        TestDictionaryAwareColumnarFilter.testFilter(TestDictionaryAwareColumnarFilter.createDictionaryBlockWithUnusedEntries(20, 2), DictionaryBlock.class);
        TestDictionaryAwareColumnarFilter.testFilter(DictionaryBlock.create((int)100, (Block)BlockAssertions.createLongsBlock(4, 5, -1), (int[])new int[100]), DictionaryBlock.class);
    }

    private static Block createDictionaryBlock(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(0, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithFailure(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize - 10);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithUnusedEntries(int dictionarySize, int blockSize) {
        ValueBlock dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize + 10);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static void testFilter(Block block, Class<? extends Block> expectedType) {
        TestDictionaryAwareColumnarFilter.testFilter(block, true, true, expectedType);
        TestDictionaryAwareColumnarFilter.testFilter(block, true, false, expectedType);
        TestDictionaryAwareColumnarFilter.testFilter(block, false, true, expectedType);
        TestDictionaryAwareColumnarFilter.testFilter(block, false, false, expectedType);
    }

    private static void testFilter(Block block, boolean selectRange, boolean usePositionsList, Class<? extends Block> expectedType) {
        DictionaryAwareColumnarFilter filter = TestDictionaryAwareColumnarFilter.createDictionaryAwareColumnarFilter(selectRange, expectedType);
        TestDictionaryAwareColumnarFilter.testFilter(filter, block, selectRange, usePositionsList);
        TestDictionaryAwareColumnarFilter.testFilter(filter, block, selectRange, usePositionsList);
    }

    private static DictionaryAwareColumnarFilter createDictionaryAwareColumnarFilter(boolean selectRange, Class<? extends Block> expectedType) {
        return new DictionaryAwareColumnarFilter((ColumnarFilter)new TestingDictionaryFilter(selectRange, expectedType));
    }

    private static void testFilter(DictionaryAwareColumnarFilter filter, Block block, boolean selectRange, boolean usePositionsList) {
        int[] outputPositions = new int[block.getPositionCount()];
        int outputPositionsCount = usePositionsList ? filter.filterPositionsList((ConnectorSession)FULL_CONNECTOR_SESSION, outputPositions, TestDictionaryAwareColumnarFilter.toPositionsList(0, block.getPositionCount()), 0, block.getPositionCount(), new Page(new Block[]{block})) : filter.filterPositionsRange((ConnectorSession)FULL_CONNECTOR_SESSION, outputPositions, 0, block.getPositionCount(), new Page(new Block[]{block}));
        IntArraySet actualSelectedPositions = new IntArraySet(Arrays.copyOfRange(outputPositions, 0, outputPositionsCount));
        IntArraySet expectedSelectedPositions = new IntArraySet(block.getPositionCount());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!TestDictionaryAwareColumnarFilter.isSelected(selectRange, BigintType.BIGINT.getLong(block, position))) continue;
            expectedSelectedPositions.add(position);
        }
        Assertions.assertThat((Collection)actualSelectedPositions).isEqualTo((Object)expectedSelectedPositions);
    }

    private static int[] toPositionsList(int offset, int length) {
        int[] positions = new int[length];
        for (int index = 0; index < length; ++index) {
            positions[index] = offset + index;
        }
        return positions;
    }

    private static boolean isSelected(boolean filterRange, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value is negative: " + value);
        }
        boolean selected = filterRange ? value > 3L && value < 11L : value % 3L == 1L;
        return selected;
    }

    private static class NegativeValueException
    extends RuntimeException {
        public NegativeValueException(long value) {
            super("value is negative: " + value);
        }
    }

    private static class TestingDictionaryFilter
    implements ColumnarFilter {
        private final boolean selectRange;
        private Class<? extends Block> expectedType;

        public TestingDictionaryFilter(boolean selectRange, Class<? extends Block> expectedType) {
            this.selectRange = selectRange;
            this.expectedType = expectedType;
        }

        public void setExpectedType(Class<? extends Block> expectedType) {
            this.expectedType = expectedType;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{3});
        }

        public int filterPositionsRange(ConnectorSession session, int[] outputPositions, int offset, int size, Page loadedPage) {
            Assertions.assertThat((int)loadedPage.getChannelCount()).isEqualTo(1);
            Block block = loadedPage.getBlock(0);
            int outputPositionsCount = 0;
            for (int position = offset; position < offset + size; ++position) {
                long value = BigintType.BIGINT.getLong(block, position);
                TestingDictionaryFilter.verifyPositive(value);
                boolean selected = TestDictionaryAwareColumnarFilter.isSelected(this.selectRange, value);
                if (!selected) continue;
                outputPositions[outputPositionsCount] = position;
                ++outputPositionsCount;
            }
            io.airlift.testing.Assertions.assertInstanceOf((Object)block, this.expectedType);
            return outputPositionsCount;
        }

        public int filterPositionsList(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, Page loadedPage) {
            Assertions.assertThat((int)loadedPage.getChannelCount()).isEqualTo(1);
            Block block = loadedPage.getBlock(0);
            int outputPositionsCount = 0;
            for (int index = offset; index < offset + size; ++index) {
                int position = activePositions[index];
                long value = BigintType.BIGINT.getLong(block, position);
                TestingDictionaryFilter.verifyPositive(value);
                boolean selected = TestDictionaryAwareColumnarFilter.isSelected(this.selectRange, value);
                if (!selected) continue;
                outputPositions[outputPositionsCount] = position;
                ++outputPositionsCount;
            }
            io.airlift.testing.Assertions.assertInstanceOf((Object)block, this.expectedType);
            return outputPositionsCount;
        }

        private static void verifyPositive(long value) {
            if (value < 0L) {
                throw new NegativeValueException(value);
            }
        }
    }
}

