/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.DesugarBetween;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestDesugarBetween {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))).describedAs("null vs non-empty range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, null)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))).describedAs("null vs empty range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, null)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "min"), (Expression)new Reference((Type)BigintType.BIGINT, "max")))).describedAs("null vs non-constant range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "min"), (Expression)new Constant((Type)BigintType.BIGINT, null)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "max"))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))).describedAs("non-constant vs non-empty range", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))).describedAs("non-constant vs empty range", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x"))), (Expression)Booleans.FALSE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)3L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))).describedAs("constant vs empty range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("constant below range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)7L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("constant in range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)7L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)7L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("constant above range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("null min, constant above range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null max, constant below range", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, null))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("null min, constant below max", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null max, constant above min", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)20L), (Expression)new Constant((Type)BigintType.BIGINT, null))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null max, non-constant value", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)), (Expression)Booleans.FALSE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))).describedAs("null min, non-constant value", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)), (Expression)Booleans.FALSE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null min/max, non-constant value", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null min/max, constant value", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (Expression)new Constant((Type)BigintType.BIGINT, null))))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "min"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null max, non-constant min", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "min")), (Expression)Booleans.FALSE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "max")))).describedAs("null min, non-constant max", new Object[0])).isEqualTo(Optional.of(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "max")), (Expression)Booleans.FALSE)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("null min/max, non-constant value", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new DesugarBetween(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

