/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateIn;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateIn {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of()))).describedAs("non-constant value", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"))))).describedAs("non-constant list", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of()))).describedAs("empty list", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of()))).describedAs("empty list", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of()))).describedAs("null value, empty list", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("null value", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("match", new Object[0])).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("no match", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("null item, no match", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new In((Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, (Object)0L))))).describedAs("null item, match", new Object[0])).isEqualTo(Optional.of(Booleans.TRUE));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateIn(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

