/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantLogicalTerms;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

class TestRemoveRedundantLogicalTerms {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());

    TestRemoveRedundantLogicalTerms() {
    }

    @Test
    void testOr() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(new Reference((Type)BooleanType.BOOLEAN, "a")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())))))).describedAs("non-deterministic repeated terms", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())))))).describedAs("mixed deterministic and non-deterministic", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of()))))));
    }

    @Test
    void testAnd() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"))))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(new Reference((Type)BooleanType.BOOLEAN, "a")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())))))).describedAs("non-deterministic repeated terms", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())))))).describedAs("mixed deterministic and non-deterministic", new Object[0])).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of())), (Object)new IsNull((Expression)new Call(RANDOM, (List)ImmutableList.of()))))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new RemoveRedundantLogicalTerms().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

