/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.DomainCoercer;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.type.Reals;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDomainCoercer {
    @Test
    public void testNone() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.none((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.none((Type)IntegerType.INTEGER));
    }

    @Test
    public void testAll() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.all((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.all((Type)IntegerType.INTEGER));
    }

    @Test
    public void testOnlyNull() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.onlyNull((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.onlyNull((Type)IntegerType.INTEGER));
    }

    @Test
    public void testCoercedValueSameAsOriginal() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)10000L, (Object)-2000L)), (Type)SmallintType.SMALLINT)).isEqualTo((Object)Domain.multipleValues((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)1L, (Object)10000L, (Object)-2000L)));
        Domain original = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)false, (Object)1.0, (boolean)false), Range.range((Type)DoubleType.DOUBLE, (Object)2.0, (boolean)true, (Object)3.0, (boolean)true), Range.greaterThan((Type)DoubleType.DOUBLE, (Object)4.0)}), (boolean)true);
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(original, (Type)RealType.REAL)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f), (boolean)false, (Object)Reals.toReal((float)1.0f), (boolean)false), Range.range((Type)RealType.REAL, (Object)Reals.toReal((float)2.0f), (boolean)true, (Object)Reals.toReal((float)3.0f), (boolean)true), Range.greaterThan((Type)RealType.REAL, (Object)Reals.toReal((float)4.0f))}), (boolean)true));
    }

    @Test
    public void testOutsideTargetTypeRange() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)10000000000L, (Object)-2000L)), (Type)SmallintType.SMALLINT)).isEqualTo((Object)Domain.multipleValues((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)1L, (Object)-2000L)));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)3.4028234663852886E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f), (boolean)true, (Object)Reals.toReal((float)Float.MAX_VALUE), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)-6.805646932770577E38, (boolean)true, (Object)3.4028234663852886E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Reals.toReal((float)Float.MAX_VALUE)), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY, (boolean)true, (Object)Double.POSITIVE_INFINITY, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Reals.toReal((float)Float.MAX_VALUE)), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)-4294967294L, (boolean)false, (Object)0x4FFFFFFF6L, (boolean)false), (Range[])new Range[0]), (boolean)true), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)Integer.MAX_VALUE), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY, (boolean)true, (Object)Double.POSITIVE_INFINITY, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)Integer.MAX_VALUE), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)-8589934588L, (boolean)false, (Object)-4294967294L, (boolean)false), (Range[])new Range[0]), (boolean)false), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.none((Type)IntegerType.INTEGER));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)-1.3611293865541154E39, (boolean)true, (Object)-6.805646932770577E38, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.onlyNull((Type)RealType.REAL));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0xFFFFFFFEL, (boolean)false, (Object)0x1FFFFFFFCL, (boolean)false), (Range[])new Range[0]), (boolean)false), (Type)IntegerType.INTEGER)).isEqualTo((Object)Domain.none((Type)IntegerType.INTEGER));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)6.805646932770577E38, (boolean)true, (Object)1.3611293865541154E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.onlyNull((Type)RealType.REAL));
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)-1.3611293865541154E39), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)1.0, (boolean)true)}), (boolean)true), (Type)RealType.REAL)).isEqualTo((Object)Domain.all((Type)RealType.REAL));
    }

    @Test
    public void testTruncatedCoercedValue() {
        Assertions.assertThat((Object)TestDomainCoercer.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DecimalType.createDecimalType((int)6, (int)3), (Object)123456L, (boolean)true, (Object)234567L, (boolean)false), (Range[])new Range[0]), (boolean)true), (Type)DecimalType.createDecimalType((int)6, (int)1))).isEqualTo((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DecimalType.createDecimalType((int)6, (int)1), (Object)1234L, (boolean)false, (Object)2345L, (boolean)true), (Range[])new Range[0]), (boolean)true));
    }

    @Test
    public void testUnsupportedCast() {
        Assertions.assertThatThrownBy(() -> TestDomainCoercer.applySaturatedCasts(Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Type)BigintType.BIGINT)).isInstanceOf(IllegalStateException.class);
    }

    private static Domain applySaturatedCasts(Domain domain, Type coercedValueType) {
        return DomainCoercer.applySaturatedCasts((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (FunctionManager)TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), (TypeOperators)TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators(), (Session)SessionTestUtils.TEST_SESSION, (Domain)domain, (Type)coercedValueType);
    }
}

