/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;

final class SymbolCardinalityMatcher
implements Matcher {
    private final int numberOfSymbols;

    SymbolCardinalityMatcher(int numberOfSymbols) {
        this.numberOfSymbols = numberOfSymbols;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(node.getOutputSymbols().size() == this.numberOfSymbols);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfSymbols", this.numberOfSymbols).toString();
    }
}

