/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class TableScanMatcher
implements Matcher {
    private final String expectedTableName;
    private final Optional<Map<String, Domain>> expectedConstraint;
    private final Optional<Boolean> hasTableLayout;

    public TableScanMatcher(String expectedTableName, Optional<Map<String, Domain>> expectedConstraint, Optional<Boolean> hasTableLayout) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Objects.requireNonNull(expectedConstraint, "expectedConstraint is null");
        this.hasTableLayout = Objects.requireNonNull(hasTableLayout, "hasTableLayout is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableScanNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableScanNode tableScanNode = (TableScanNode)node;
        CatalogSchemaTableName tableName = metadata.getTableName(session, tableScanNode.getTable());
        String actualTableName = tableName.getSchemaTableName().getTableName();
        if (!this.expectedTableName.equalsIgnoreCase(actualTableName)) {
            return MatchResult.NO_MATCH;
        }
        if (!TableScanMatcher.domainsMatch(this.expectedConstraint, (TupleDomain<ColumnHandle>)tableScanNode.getEnforcedConstraint(), tableScanNode.getTable(), session, metadata)) {
            return MatchResult.NO_MATCH;
        }
        return new MatchResult(true);
    }

    private static boolean domainsMatch(Optional<Map<String, Domain>> expectedDomains, TupleDomain<ColumnHandle> actualConstraint, TableHandle tableHandle, Session session, Metadata metadata) {
        if (expectedDomains.isEmpty()) {
            return true;
        }
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        TupleDomain expected = TupleDomain.withColumnDomains(expectedDomains.get()).transformKeys(columnHandles::get);
        return expected.equals(actualConstraint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedTableName", (Object)this.expectedTableName).add("expectedConstraint", this.expectedConstraint.orElse(null)).add("hasTableLayout", this.hasTableLayout.orElse(null)).toString();
    }
}

