/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SetOperationOutputMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementExceptAll;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestImplementExceptAll
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction SUBTRACT_BIGINT = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction GREATEST = FUNCTIONS.resolveFunction("GREATEST", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));

    public TestImplementExceptAll() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());
        this.tester().assertThat((Rule<?>)new ImplementExceptAll(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol a1 = p.symbol("a_1");
            Symbol a2 = p.symbol("a_2");
            Symbol b = p.symbol("b");
            Symbol b1 = p.symbol("b_1");
            Symbol b2 = p.symbol("b_2");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)a, (Object)a1).put((Object)a, (Object)a2).put((Object)b, (Object)b1).put((Object)b, (Object)b2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a1, b1), (Object)p.values(a2, b2)), false);
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "row_number"), (Expression)new Call(GREATEST, (List)ImmutableList.of((Object)new Call(SUBTRACT_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "count_1"), (Object)new Reference((Type)BigintType.BIGINT, "count_2"))), (Object)new Constant((Type)BigintType.BIGINT, (Object)0L)))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"count_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "count_1")), (Object)"count_2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "count_2")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "row_number"))), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("count_1", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of((Object)"marker_1"), frame)).addFunction("count_2", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of((Object)"marker_2"), frame)).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), frame)), PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a_1")), (Object)"b1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b_1")), (Object)"marker_left_1", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE), (Object)"marker_left_2", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)BooleanType.BOOLEAN, null))), PlanMatchPattern.values("a_1", "b_1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a_2")), (Object)"b2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b_2")), (Object)"marker_right_1", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)"marker_right_2", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.values("a_2", "b_2"))).withAlias("a", (RvalueMatcher)new SetOperationOutputMatcher(0)).withAlias("b", (RvalueMatcher)new SetOperationOutputMatcher(1)).withAlias("marker_1", (RvalueMatcher)new SetOperationOutputMatcher(2)).withAlias("marker_2", (RvalueMatcher)new SetOperationOutputMatcher(3)))))));
    }
}

