/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeUnion;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnionNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestMergeUnion
extends BaseRuleTest {
    public TestMergeUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testFlattening() {
        this.tester().assertThat((Rule<?>)new MergeUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            UnionNode u1 = p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            UnionNode u2 = p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)u2));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("a"), PlanMatchPattern.values("b")));
    }

    @Test
    public void testMixedFlattening() {
        this.tester().assertThat((Rule<?>)new MergeUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            UnionNode u1 = p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)p.values(1, d)));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("d")));
    }

    @Test
    public void testNotFlattening() {
        this.tester().assertThat((Rule<?>)new MergeUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
        }).doesNotFire();
    }
}

