/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneExceptSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneExceptSourceColumns
extends BaseRuleTest {
    public TestPruneExceptSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneOneChild() {
        this.tester().assertThat((Rule<?>)new PruneExceptSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)c), (List<PlanNode>)ImmutableList.of((Object)p.values(a, b), (Object)p.values(c)));
        }).matches(PlanMatchPattern.except(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testPruneAllChildren() {
        this.tester().assertThat((Rule<?>)new PruneExceptSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)c), (List<PlanNode>)ImmutableList.of((Object)p.values(a, b), (Object)p.values(c, d)));
        }).matches(PlanMatchPattern.except(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c"))), PlanMatchPattern.values("c", "d"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneExceptSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(a), (Object)p.values(b)));
        }).doesNotFire();
    }
}

