/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneExchangeSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneExchangeSourceColumns
extends BaseRuleTest {
    public TestPruneExchangeSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneOneChild() {
        this.tester().assertThat((Rule<?>)new PruneExchangeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c1 = p.symbol("c_1");
            Symbol c2 = p.symbol("c_2");
            return p.exchange(e -> e.addSource((PlanNode)p.values(b)).addInputsSet(b).addSource((PlanNode)p.values(c1, c2)).addInputsSet(c1).singleDistributionPartitioningScheme(a));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c_1"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c_1", (Object)"c_2")))));
    }

    @Test
    public void testPruneAllChildren() {
        this.tester().assertThat((Rule<?>)new PruneExchangeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b1 = p.symbol("b_1");
            Symbol b2 = p.symbol("b_2");
            Symbol c1 = p.symbol("c_1");
            Symbol c2 = p.symbol("c_2");
            return p.exchange(e -> e.addSource((PlanNode)p.values(b1, b2)).addInputsSet(b1).addSource((PlanNode)p.values(c1, c2)).addInputsSet(c1).singleDistributionPartitioningScheme(a));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b_1"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_1", (Object)"b_2"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c_1"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c_1", (Object)"c_2")))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneExchangeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.exchange(e -> e.addSource((PlanNode)p.values(b)).addInputsSet(b).addSource((PlanNode)p.values(c)).addInputsSet(c).singleDistributionPartitioningScheme(a));
        }).doesNotFire();
    }
}

