/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneIndexJoinColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneIndexJoinColumns
extends BaseRuleTest {
    public TestPruneIndexJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumn() {
        this.tester().assertThat((Rule<?>)new PruneIndexJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), p.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b, c), (List<IndexJoinNode.EquiJoinClause>)ImmutableList.of((Object)new IndexJoinNode.EquiJoinClause(a, b)), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.indexJoin(IndexJoinNode.Type.INNER, (List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.indexJoinEquiClause("a", "b")), Optional.empty(), Optional.empty(), PlanMatchPattern.values("a"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.values("b", "c")))));
        this.tester().assertThat((Rule<?>)new PruneIndexJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, c}), p.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)p.values(a, b), (PlanNode)p.values(c, d), (List<IndexJoinNode.EquiJoinClause>)ImmutableList.of((Object)new IndexJoinNode.EquiJoinClause(a, c)), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c"))), PlanMatchPattern.indexJoin(IndexJoinNode.Type.INNER, (List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.indexJoinEquiClause("a", "c")), Optional.empty(), Optional.empty(), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c"))), PlanMatchPattern.values("c", "d")))));
    }

    @Test
    public void testDoNotPruneEquiClauseSymbol() {
        this.tester().assertThat((Rule<?>)new PruneIndexJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), p.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (List<IndexJoinNode.EquiJoinClause>)ImmutableList.of((Object)new IndexJoinNode.EquiJoinClause(a, b)), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneHashSymbol() {
        this.tester().assertThat((Rule<?>)new PruneIndexJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol h = p.symbol("h");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), p.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b, h), (List<IndexJoinNode.EquiJoinClause>)ImmutableList.of((Object)new IndexJoinNode.EquiJoinClause(a, b)), Optional.empty(), Optional.of(h)));
        }).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneIndexJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b, c}), p.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b, c), (List<IndexJoinNode.EquiJoinClause>)ImmutableList.of((Object)new IndexJoinNode.EquiJoinClause(a, b)), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }
}

