/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.TopNRankingSymbolMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTopNRankingColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneTopNRankingColumns
extends BaseRuleTest {
    public TestPruneTopNRankingColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotPrunePartitioningSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b, ranking}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)b), (Map)ImmutableMap.of((Object)b, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.empty(), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneOrderingSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{ranking}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.empty(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneHashSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol hash = p.symbol("hash");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, ranking}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.of(hash), (PlanNode)p.values(a, hash)));
        }).doesNotFire();
    }

    @Test
    public void testSourceSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, ranking}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.empty(), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"ranking", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ranking"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).rankingType(TopNRankingNode.RankingType.ROW_NUMBER).maxRankingPerPartition(5), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b"))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher())));
    }

    @Test
    public void testAllSymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b, ranking}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.empty(), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testRankingSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRankingColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, ranking, Optional.empty(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

