/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantEnforceSingleRowNode
extends BaseRuleTest {
    public TestRemoveRedundantEnforceSingleRowNode() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveEnforceWhenSourceScalar() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("a")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.values("a")));
    }

    @Test
    public void testDoNotFireWhenSourceNotScalar() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.values(10, p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }
}

