/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.Session;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonArrayFunction {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCreateEmptyArray() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array()"))).matches("VALUES VARCHAR '[]'");
    }

    @Test
    public void testMultipleElements() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(1, true)"))).matches("VALUES VARCHAR '[1,true]'");
    }

    @Test
    public void testNullElement() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(null)"))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(null ABSENT ON NULL)"))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(null NULL ON NULL)"))).matches("VALUES VARCHAR '[null]'");
    }

    @Test
    public void testDuplicateElement() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(1, 1)"))).matches("VALUES VARCHAR '[1,1]'");
    }

    @Test
    public void testElementWithFormat() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array('{\"a\" : 1}' FORMAT JSON)"))).matches("VALUES VARCHAR '[{\"a\":1}]'");
        byte[] bytes = "{\"a\" : 1}".getBytes(StandardCharsets.UTF_16LE);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF16)"))).matches("VALUES VARCHAR '[{\"a\":1}]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array('[...' FORMAT JSON)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array('{\"a\" : 1, \"a\" : 1}' FORMAT JSON)"))).matches("VALUES VARCHAR '[{\"a\":1}]'");
    }

    @Test
    public void testElementTypes() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(1e0)"))).matches("VALUES VARCHAR '[1.0]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59')"))).matches("VALUES VARCHAR '[\"12151fd2-7586-11e9-8f9e-2a86e4085a59\"]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(DATE '2001-01-31')"))).matches("VALUES VARCHAR '[\"2001-01-31\"]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(approx_set(1))"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testJsonReturningFunctionAsElement() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(json_array(1))"))).matches("VALUES VARCHAR '[[1]]'");
    }

    @Test
    public void testSubqueries() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array((SELECT 1))"))).matches("VALUES VARCHAR '[1]'");
    }

    @Test
    public void testOutputFormat() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true)"))).matches("VALUES VARCHAR '[true]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varchar)"))).matches("VALUES VARCHAR '[true]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varchar FORMAT JSON)"))).matches("VALUES VARCHAR '[true]'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varchar(100))"))).matches("VALUES CAST('[true]' AS varchar(100))");
        String output = "[true]";
        byte[] bytes = output.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varbinary FORMAT JSON ENCODING UTF8)"))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varbinary FORMAT JSON ENCODING UTF16)"))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(Charset.forName("UTF_32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array(true RETURNING varbinary FORMAT JSON ENCODING UTF32)"))).matches("VALUES " + varbinaryLiteral);
    }

    @Test
    public void testNestedAggregation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT json_array('x', max(a))\nFROM (VALUES ('abc'), ('def')) t(a)\n"))).matches("VALUES VARCHAR '[\"x\",\"def\"]'");
    }

    @Test
    public void testParameters() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).addPreparedStatement("my_query", "SELECT json_array(?, ?)").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "EXECUTE my_query USING 'a', 1"))).matches("VALUES VARCHAR '[\"a\",1]'");
    }
}

