/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.util.FastutilSetHelper;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFastutilSetHelper {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();

    @Test
    void testCreateTupleDomainFilters() {
        for (TestInput testInput : TestFastutilSetHelper.testInputs()) {
            for (Block inputValues : testInput.getInputs()) {
                long min;
                Type type = testInput.getType();
                List values = (List)IntStream.range(0, inputValues.getPositionCount()).mapToLong(index -> type.getLong(inputValues, index)).boxed().collect(ImmutableList.toImmutableList());
                Set filter = FastutilSetHelper.toFastutilHashSet((Set)ImmutableSet.copyOf((Collection)values), (Type)type, (MethodHandle)TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})), (MethodHandle)TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})));
                Assertions.assertThat((Collection)filter).isInstanceOf(AbstractLongSet.class);
                for (Object value : values) {
                    Assertions.assertThat((boolean)filter.contains((long)((Long)value))).isTrue();
                }
                long minValue = ((Number)type.getRange().map(Type.Range::getMin).orElse(Long.MIN_VALUE)).longValue();
                long maxValue = ((Number)type.getRange().map(Type.Range::getMax).orElse(Long.MAX_VALUE)).longValue();
                Assertions.assertThat((boolean)filter.contains(minValue)).isFalse();
                Assertions.assertThat((boolean)filter.contains(maxValue)).isFalse();
                long max = min = ((Long)values.get(0)).longValue();
                for (int i = 1; i < values.size(); ++i) {
                    min = Math.min(min, (Long)values.get(i));
                    max = Math.max(max, (Long)values.get(i));
                }
                Assertions.assertThat((boolean)filter.contains(min - 1L)).isFalse();
                Assertions.assertThat((boolean)filter.contains(max + 1L)).isFalse();
            }
        }
    }

    private static List<TestInput> testInputs() {
        return ImmutableList.of((Object)new TestInput((Type)IntegerType.INTEGER, TestFastutilSetHelper.longInputValues()), (Object)new TestInput((Type)BigintType.BIGINT, TestFastutilSetHelper.longInputValues()), (Object)new TestInput((Type)SmallintType.SMALLINT, TestFastutilSetHelper.longInputValues()), (Object)new TestInput((Type)TinyintType.TINYINT, (List<List<?>>)ImmutableList.of((Object)ImmutableList.of((Object)-100L, (Object)100L, (Object)120L), (Object)ImmutableList.of((Object)100L, (Object)102L, (Object)104L, (Object)105L))), (Object)new TestInput((Type)RealType.REAL, TestFastutilSetHelper.floatInputValues()), (Object)new TestInput((Type)TimestampType.TIMESTAMP_SECONDS, TestFastutilSetHelper.timestampInputValues(0)), (Object)new TestInput((Type)TimestampType.TIMESTAMP_MILLIS, TestFastutilSetHelper.timestampInputValues(3)), (Object)new TestInput((Type)TimestampType.TIMESTAMP_MICROS, TestFastutilSetHelper.timestampInputValues(6)), (Object)new TestInput((Type)TimeType.TIME_SECONDS, TestFastutilSetHelper.timeInputValues(0)), (Object)new TestInput((Type)TimeType.TIME_MILLIS, TestFastutilSetHelper.timeInputValues(3)), (Object)new TestInput((Type)TimeType.TIME_MICROS, TestFastutilSetHelper.timeInputValues(6)), (Object)new TestInput((Type)TimeType.TIME_NANOS, TestFastutilSetHelper.timeInputValues(9)), (Object[])new TestInput[]{new TestInput((Type)TimeType.TIME_PICOS, TestFastutilSetHelper.timeInputValues(12)), new TestInput((Type)DateType.DATE, TestFastutilSetHelper.longInputValues()), new TestInput((Type)DecimalType.createDecimalType((int)5, (int)0), TestFastutilSetHelper.longInputValues()), new TestInput((Type)DecimalType.createDecimalType((int)7, (int)2), TestFastutilSetHelper.longInputValues())});
    }

    private static List<List<?>> longInputValues() {
        return ImmutableList.of((Object)ImmutableList.of((Object)-100L, (Object)0L, (Object)1L, (Object)3L, (Object)500L, (Object)7000L), (Object)ImmutableList.of((Object)1L, (Object)3L, (Object)7L, (Object)12L, (Object)14L));
    }

    private static List<List<?>> floatInputValues() {
        return ImmutableList.of((Object)ImmutableList.of((Object)Float.floatToRawIntBits(-123122.03f), (Object)Float.floatToRawIntBits(3424.4f), (Object)Float.floatToRawIntBits(989.998f)), (Object)ImmutableList.of((Object)Float.floatToRawIntBits(1.2342f), (Object)Float.floatToRawIntBits(3.56f), (Object)Float.floatToRawIntBits(7.4f), (Object)Float.floatToRawIntBits(12.1f), (Object)Float.floatToRawIntBits(14.0f)));
    }

    private static List<List<?>> timeInputValues(int precision) {
        return (List)ImmutableList.of((Object)ImmutableList.of((Object)1000000000000L, (Object)1000000003000L, (Object)1000004000000L, (Object)1005000000000L, (Object)1060000000000L), (Object)ImmutableList.of((Object)1000000000001L, (Object)1000000000003L, (Object)1000000000007L, (Object)1000000000012L, (Object)1000000000014L)).stream().map(inputs -> (ImmutableList)inputs.stream().map(value -> SqlTime.newInstance((int)12, (long)value).roundTo(precision).getPicos()).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    private static List<List<?>> timestampInputValues(int precision) {
        return (List)ImmutableList.of((Object)ImmutableList.of((Object)1000000000000L, (Object)1000000003000L, (Object)1000004000000L, (Object)1005000000000L, (Object)1060000000000L), (Object)ImmutableList.of((Object)1000000000001L, (Object)1000000000003L, (Object)1000000000007L, (Object)1000000000012L, (Object)1000000000014L)).stream().map(inputs -> (ImmutableList)inputs.stream().map(value -> SqlTimestamp.newInstance((int)12, (long)value, (int)0).roundTo(precision).getEpochMicros()).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    private static class TestInput {
        private final Type type;
        private final List<Block> inputs;

        private TestInput(Type type, List<List<?>> inputs) {
            this.type = type;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List<?> values : inputs) {
                BlockBuilder blockBuilder = type.createBlockBuilder(null, inputs.size());
                for (Object value : values) {
                    TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, value);
                }
                builder.add((Object)blockBuilder.build());
            }
            this.inputs = builder.build();
        }

        public Type getType() {
            return this.type;
        }

        public List<Block> getInputs() {
            return this.inputs;
        }
    }
}

