/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.annotation.NotThreadSafe;
import io.trino.execution.executor.scheduler.FairScheduler;
import io.trino.execution.executor.scheduler.TaskControl;

@NotThreadSafe
public final class SchedulerContext {
    private final FairScheduler scheduler;
    private final TaskControl handle;

    public SchedulerContext(FairScheduler scheduler, TaskControl handle) {
        this.scheduler = scheduler;
        this.handle = handle;
    }

    public boolean maybeYield() {
        Preconditions.checkArgument((this.handle.getState() == TaskControl.State.RUNNING ? 1 : 0) != 0, (Object)"Task is not running");
        return this.scheduler.yield(this.handle);
    }

    public boolean block(ListenableFuture<?> future) {
        Preconditions.checkArgument((this.handle.getState() == TaskControl.State.RUNNING ? 1 : 0) != 0, (Object)"Task is not running");
        return this.scheduler.block(this.handle, future);
    }

    public long getStartNanos() {
        return this.scheduler.getStartNanos(this.handle);
    }

    public long getWaitNanos() {
        return this.scheduler.getWaitNanos(this.handle);
    }

    public long getScheduledNanos() {
        return this.scheduler.getScheduledNanos(this.handle);
    }

    public long getBlockedNanos() {
        return this.scheduler.getBlockedNanos(this.handle);
    }
}

