/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.util.Objects;

public final class CombineHashFunction {
    private CombineHashFunction() {
    }

    @ScalarFunction(value="combine_hash", hidden=true)
    @SqlType(value="bigint")
    public static long getHash(@SqlType(value="bigint") long previousHashValue, @SqlType(value="bigint") long value) {
        return 31L * previousHashValue + value;
    }

    @UsedByGeneratedCode
    public static void combineAllHashesWithConstant(long[] hashes, int fromIndex, int toIndex, long value) {
        Objects.checkFromToIndex(fromIndex, toIndex, hashes.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            hashes[i] = 31L * hashes[i] + value;
        }
    }
}

