/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class ExternalUriInfo {
    private static final String X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    private final UriInfo uriInfo;
    private final String forwardedPrefix;

    public ExternalUriInfo(@Context UriInfo uriInfo, @HeaderParam(value="X-Forwarded-Prefix") String forwardedPrefix) {
        this.uriInfo = Objects.requireNonNull(uriInfo, "uriInfo is null");
        this.forwardedPrefix = Objects.requireNonNullElse(forwardedPrefix, "");
    }

    public static ExternalUriInfo from(ContainerRequestContext requestContext) {
        return new ExternalUriInfo(requestContext.getUriInfo(), requestContext.getHeaderString(X_FORWARDED_PREFIX));
    }

    public ExternalUriBuilder baseUriBuilder() {
        return new ExternalUriBuilder(this.uriInfo.getBaseUriBuilder().replacePath(this.forwardedPrefix).replaceQuery(""));
    }

    public URI absolutePath(String path) {
        return this.baseUriBuilder().path(path).build();
    }

    public URI fullRequestUri() {
        return this.uriInfo.getRequestUriBuilder().replacePath(this.forwardedPrefix).path(this.uriInfo.getPath()).build(new Object[0]);
    }

    public static class ExternalUriBuilder {
        private final UriBuilder uriBuilder;

        private ExternalUriBuilder(UriBuilder uriBuilder) {
            this.uriBuilder = Objects.requireNonNull(uriBuilder, "uriBuilder is null");
        }

        public ExternalUriBuilder path(String path) {
            this.uriBuilder.path(path);
            return this;
        }

        public ExternalUriBuilder replaceQuery(String query) {
            this.uriBuilder.replaceQuery(query);
            return this;
        }

        public ExternalUriBuilder rawReplaceQuery(String rawEncodedQuery) {
            try {
                this.uriBuilder.uri(new URI(null, null, null, rawEncodedQuery, null));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return this;
        }

        public URI build() throws IllegalArgumentException, UriBuilderException {
            return this.uriBuilder.build(new Object[0]);
        }
    }
}

