/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.Lz4QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.ZstdQueryDataEncoder;
import io.trino.spi.Page;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import io.trino.type.SqlIntervalDayTime;
import io.trino.type.SqlIntervalYearMonth;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonQueryDataEncoder
implements QueryDataEncoder {
    private static final String ENCODING = "json";
    private final Session session;
    private final List<OutputColumn> columns;
    private final ObjectMapper mapper;

    public JsonQueryDataEncoder(ObjectMapper mapper, Session session, List<OutputColumn> columns) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataAttributes encodeTo(OutputStream output, List<Page> pages) throws IOException {
        JsonFactory jsonFactory = JsonUtils.jsonFactory();
        try (CountingOutputStream wrapper = new CountingOutputStream(output);){
            DataAttributes dataAttributes;
            block16: {
                JsonGenerator generator = jsonFactory.createGenerator((OutputStream)wrapper);
                try {
                    generator.writeStartArray();
                    for (Page page : pages) {
                        for (int position = 0; position < page.getPositionCount(); ++position) {
                            generator.writeStartArray();
                            for (OutputColumn column : this.columns) {
                                Object value = column.type().getObjectValue(this.session.toConnectorSession(), page.getBlock(column.sourcePageChannel()), position);
                                JsonQueryDataEncoder.writeValue(this.mapper, generator, value);
                            }
                            generator.writeEndArray();
                        }
                    }
                    generator.writeEndArray();
                    generator.flush();
                    dataAttributes = DataAttributes.builder().set(DataAttribute.SEGMENT_SIZE, (Object)Math.toIntExact(wrapper.getCount())).build();
                    if (generator == null) break block16;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return dataAttributes;
        }
        catch (JsonProcessingException e) {
            throw new IOException("Could not serialize to JSON", e);
        }
    }

    private static void writeValue(ObjectMapper mapper, JsonGenerator generator, Object value) throws IOException {
        Object object = value;
        int n = 0;
        block22: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Double.class, Double.class, Float.class, Float.class, Number.class, SqlDate.class, SqlDecimal.class, SqlIntervalDayTime.class, SqlIntervalYearMonth.class, SqlTime.class, SqlTimeWithTimeZone.class, SqlTimestamp.class, SqlTimestampWithTimeZone.class, SqlVarbinary.class, String.class, byte[].class, List.class, Map.class}, (Object)object, n)) {
                case -1: {
                    generator.writeNull();
                    break block22;
                }
                case 0: {
                    Boolean booleanValue = (Boolean)object;
                    generator.writeBoolean(booleanValue.booleanValue());
                    break block22;
                }
                case 1: {
                    Double doubleValue = (Double)object;
                    if (!doubleValue.isInfinite()) {
                        n = 2;
                        continue block22;
                    }
                    generator.writeString(doubleValue.toString());
                    break block22;
                }
                case 2: {
                    Double doubleValue = (Double)object;
                    if (!doubleValue.isNaN()) {
                        n = 3;
                        continue block22;
                    }
                    generator.writeString("NaN");
                    break block22;
                }
                case 3: {
                    Float floatValue = (Float)object;
                    if (!floatValue.isInfinite()) {
                        n = 4;
                        continue block22;
                    }
                    generator.writeString(floatValue.toString());
                    break block22;
                }
                case 4: {
                    Float floatValue = (Float)object;
                    if (!floatValue.isNaN()) {
                        n = 5;
                        continue block22;
                    }
                    generator.writeString("NaN");
                    break block22;
                }
                case 5: {
                    Number numberValue = (Number)object;
                    generator.writeNumber(numberValue.toString());
                    break block22;
                }
                case 6: {
                    SqlDate dateValue = (SqlDate)object;
                    generator.writeString(dateValue.toString());
                    break block22;
                }
                case 7: {
                    SqlDecimal decimalValue = (SqlDecimal)object;
                    generator.writeString(decimalValue.toString());
                    break block22;
                }
                case 8: {
                    SqlIntervalDayTime intervalValue = (SqlIntervalDayTime)object;
                    generator.writeString(intervalValue.toString());
                    break block22;
                }
                case 9: {
                    SqlIntervalYearMonth intervalValue = (SqlIntervalYearMonth)object;
                    generator.writeString(intervalValue.toString());
                    break block22;
                }
                case 10: {
                    SqlTime timeValue = (SqlTime)object;
                    generator.writeString(timeValue.toString());
                    break block22;
                }
                case 11: {
                    SqlTimeWithTimeZone timeWithTimeZone = (SqlTimeWithTimeZone)object;
                    generator.writeString(timeWithTimeZone.toString());
                    break block22;
                }
                case 12: {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    generator.writeString(timestamp.toString());
                    break block22;
                }
                case 13: {
                    SqlTimestampWithTimeZone timestampWithTimeZone = (SqlTimestampWithTimeZone)object;
                    generator.writeString(timestampWithTimeZone.toString());
                    break block22;
                }
                case 14: {
                    SqlVarbinary varbinaryValue = (SqlVarbinary)object;
                    generator.writeBinary(varbinaryValue.getBytes());
                    break block22;
                }
                case 15: {
                    String stringValue = (String)object;
                    generator.writeString(stringValue);
                    break block22;
                }
                case 16: {
                    byte[] binaryValue = (byte[])object;
                    generator.writeBinary(binaryValue);
                    break block22;
                }
                case 17: {
                    List listValue = (List)object;
                    generator.writeStartArray();
                    for (Object element : listValue) {
                        JsonQueryDataEncoder.writeValue(mapper, generator, element);
                    }
                    generator.writeEndArray();
                    break block22;
                }
                case 18: {
                    Map mapValue = (Map)object;
                    generator.writeStartObject();
                    for (Map.Entry entry : mapValue.entrySet()) {
                        generator.writeFieldName(entry.getKey().toString());
                        JsonQueryDataEncoder.writeValue(mapper, generator, entry.getValue());
                    }
                    generator.writeEndObject();
                    break block22;
                }
                default: {
                    mapper.writeValue(generator, value);
                    break block22;
                }
            }
            break;
        }
    }

    @Override
    public String encoding() {
        return ENCODING;
    }

    public static class Lz4Factory
    extends Factory {
        @Inject
        public Lz4Factory(ObjectMapper mapper) {
            super(mapper);
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new Lz4QueryDataEncoder(super.create(session, columns));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+lz4";
        }
    }

    public static class ZstdFactory
    extends Factory {
        @Inject
        public ZstdFactory(ObjectMapper mapper) {
            super(mapper);
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new ZstdQueryDataEncoder(super.create(session, columns));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+zstd";
        }
    }

    public static class Factory
    implements QueryDataEncoder.Factory {
        protected final JsonFactory factory = JsonUtils.jsonFactory();
        private final ObjectMapper mapper;

        @Inject
        public Factory(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new JsonQueryDataEncoder(this.mapper, session, columns);
        }

        @Override
        public String encoding() {
            return JsonQueryDataEncoder.ENCODING;
        }
    }
}

