/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import io.trino.operator.project.DictionaryAwarePageFilter;
import io.trino.operator.project.PageFilter;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.sql.gen.columnar.FilterEvaluator;

public final class PageFilterEvaluator
implements FilterEvaluator {
    private final PageFilter filter;

    public PageFilterEvaluator(PageFilter filter) {
        this.filter = filter.getInputChannels().size() == 1 && filter.isDeterministic() ? new DictionaryAwarePageFilter(filter) : filter;
    }

    @Override
    public FilterEvaluator.SelectionResult evaluate(ConnectorSession session, SelectedPositions activePositions, Page page) {
        Page inputPage = this.filter.getInputChannels().getInputChannels(page);
        long start = System.nanoTime();
        SelectedPositions selectedPositions = this.filter.filter(session, inputPage);
        return new FilterEvaluator.SelectionResult(selectedPositions, System.nanoTime() - start);
    }
}

