/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.Optional;

public class DistributeComparisonOverCase
implements IrOptimizerRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Comparison.Operator operator;
        Object object;
        Comparison comparison;
        if (expression instanceof Comparison) {
            comparison = (Comparison)expression;
            operator = object = comparison.operator();
            object = comparison.left();
            if (object instanceof Case) {
                Case caseTerm = (Case)object;
                Object target = object = comparison.right();
                if (target instanceof Reference || target instanceof Constant) {
                    return Optional.of(this.distribute(operator, caseTerm, (Expression)target));
                }
            }
        }
        if (!(expression instanceof Comparison)) return Optional.empty();
        comparison = (Comparison)expression;
        try {
            operator = object = comparison.operator();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object target = object = comparison.left();
        object = comparison.right();
        if (!(object instanceof Case)) return Optional.empty();
        Case caseTerm = (Case)object;
        if (!(target instanceof Reference) && !(target instanceof Constant)) return Optional.empty();
        return Optional.of(this.distribute(this.flipOperator(operator), caseTerm, (Expression)target));
    }

    private Comparison.Operator flipOperator(Comparison.Operator operator) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case Comparison.Operator.IDENTICAL, Comparison.Operator.EQUAL, Comparison.Operator.NOT_EQUAL -> operator;
            case Comparison.Operator.LESS_THAN -> Comparison.Operator.GREATER_THAN;
            case Comparison.Operator.LESS_THAN_OR_EQUAL -> Comparison.Operator.GREATER_THAN_OR_EQUAL;
            case Comparison.Operator.GREATER_THAN -> Comparison.Operator.LESS_THAN;
            case Comparison.Operator.GREATER_THAN_OR_EQUAL -> Comparison.Operator.LESS_THAN_OR_EQUAL;
        };
    }

    private Expression distribute(Comparison.Operator operator, Case caseTerm, Expression target) {
        return new Case(caseTerm.whenClauses().stream().map(clause -> new WhenClause(clause.getOperand(), new Comparison(operator, clause.getResult(), target))).toList(), new Comparison(operator, caseTerm.defaultValue(), target));
    }
}

