/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimplifyRedundantCase
implements IrOptimizerRule {
    private final Metadata metadata;

    public SimplifyRedundantCase(PlannerContext context) {
        this.metadata = context.getMetadata();
    }

    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Case)) {
            return Optional.empty();
        }
        Case caseTerm = (Case)expression;
        Expression defaultValue = caseTerm.defaultValue();
        if (!caseTerm.whenClauses().stream().map(WhenClause::getResult).allMatch(result -> result.equals(Booleans.TRUE) || result.equals(Booleans.FALSE)) || !defaultValue.equals(Booleans.TRUE) && !defaultValue.equals(Booleans.FALSE) || caseTerm.whenClauses().stream().map(WhenClause::getOperand).anyMatch(e -> !DeterminismEvaluator.isDeterministic(e))) {
            return Optional.empty();
        }
        if (defaultValue.equals(Booleans.FALSE)) {
            List<Expression> operands = caseTerm.whenClauses().stream().filter(clause -> clause.getResult().equals(Booleans.TRUE)).map(WhenClause::getOperand).toList();
            return Optional.of(new Comparison(Comparison.Operator.IDENTICAL, IrUtils.or(operands), Booleans.TRUE));
        }
        List<Expression> operands = caseTerm.whenClauses().stream().filter(clause -> clause.getResult().equals(Booleans.FALSE)).map(WhenClause::getOperand).toList();
        return Optional.of(IrExpressions.not(this.metadata, new Comparison(Comparison.Operator.IDENTICAL, IrUtils.or(operands), Booleans.TRUE)));
    }
}

