/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SetOperationNode;
import io.trino.sql.planner.plan.UnionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class SetOperationMerge {
    private final Rule.Context context;
    private final SetOperationNode node;
    private final List<PlanNode> newSources;

    public SetOperationMerge(SetOperationNode node, Rule.Context context) {
        this.node = node;
        this.context = context;
        this.newSources = new ArrayList<PlanNode>();
    }

    public Optional<SetOperationNode> mergeFirstSource() {
        Lookup lookup = this.context.getLookup();
        List sources = (List)this.node.getSources().stream().map(lookup::resolve).collect(ImmutableList.toImmutableList());
        PlanNode child = (PlanNode)sources.get(0);
        Optional<Boolean> mergedQuantifier = this.mergedQuantifierIsDistinct(this.node, child);
        if (mergedQuantifier.isEmpty()) {
            return Optional.empty();
        }
        ImmutableListMultimap.Builder newMappingsBuilder = ImmutableListMultimap.builder();
        this.addMergedMappings((SetOperationNode)child, 0, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        for (int i = 1; i < sources.size(); ++i) {
            PlanNode source = (PlanNode)sources.get(i);
            this.addOriginalMappings(source, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        }
        if (this.node instanceof UnionNode) {
            return Optional.of(new UnionNode(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols()));
        }
        if (this.node instanceof IntersectNode) {
            return Optional.of(new IntersectNode(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols(), mergedQuantifier.get()));
        }
        if (this.node instanceof ExceptNode) {
            return Optional.of(new ExceptNode(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols(), mergedQuantifier.get()));
        }
        throw new IllegalArgumentException("unexpected node type: " + this.node.getClass().getSimpleName());
    }

    public Optional<SetOperationNode> merge() {
        Preconditions.checkState((this.node instanceof UnionNode || this.node instanceof IntersectNode ? 1 : 0) != 0, (String)"unexpected node type: %s", (Object)this.node.getClass().getSimpleName());
        Lookup lookup = this.context.getLookup();
        List sources = (List)this.node.getSources().stream().map(lookup::resolve).collect(ImmutableList.toImmutableList());
        ImmutableListMultimap.Builder newMappingsBuilder = ImmutableListMultimap.builder();
        boolean resultIsDistinct = false;
        boolean rewritten = false;
        for (int i = 0; i < sources.size(); ++i) {
            PlanNode source = (PlanNode)sources.get(i);
            Optional<Boolean> mergedQuantifier = this.mergedQuantifierIsDistinct(this.node, source);
            if (mergedQuantifier.isPresent()) {
                this.addMergedMappings((SetOperationNode)source, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
                resultIsDistinct |= mergedQuantifier.get().booleanValue();
                rewritten = true;
                continue;
            }
            this.addOriginalMappings(source, i, (ImmutableListMultimap.Builder<Symbol, Symbol>)newMappingsBuilder);
        }
        if (!rewritten) {
            return Optional.empty();
        }
        if (this.node instanceof UnionNode) {
            return Optional.of(new UnionNode(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols()));
        }
        return Optional.of(new IntersectNode(this.node.getId(), this.newSources, (ListMultimap<Symbol, Symbol>)newMappingsBuilder.build(), this.node.getOutputSymbols(), resultIsDistinct));
    }

    private Optional<Boolean> mergedQuantifierIsDistinct(SetOperationNode node, PlanNode child) {
        if (!node.getClass().equals(child.getClass())) {
            return Optional.empty();
        }
        if (node instanceof UnionNode) {
            return Optional.of(false);
        }
        if (node instanceof IntersectNode) {
            if (!((IntersectNode)node).isDistinct() && !((IntersectNode)child).isDistinct()) {
                return Optional.of(false);
            }
            return Optional.of(true);
        }
        Preconditions.checkState((boolean)(node instanceof ExceptNode), (String)"unexpected node type: %s", (Object)node.getClass().getSimpleName());
        if (((ExceptNode)node).isDistinct() && !((ExceptNode)child).isDistinct()) {
            return Optional.empty();
        }
        return Optional.of(((ExceptNode)child).isDistinct());
    }

    private void addMergedMappings(SetOperationNode child, int childIndex, ImmutableListMultimap.Builder<Symbol, Symbol> newMappingsBuilder) {
        this.newSources.addAll(child.getSources());
        for (Map.Entry mapping : this.node.getSymbolMapping().asMap().entrySet()) {
            Symbol input = (Symbol)Iterables.get((Iterable)((Iterable)mapping.getValue()), (int)childIndex);
            newMappingsBuilder.putAll((Object)((Symbol)mapping.getKey()), (Iterable)child.getSymbolMapping().get((Object)input));
        }
    }

    private void addOriginalMappings(PlanNode child, int childIndex, ImmutableListMultimap.Builder<Symbol, Symbol> newMappingsBuilder) {
        this.newSources.add(child);
        for (Map.Entry mapping : this.node.getSymbolMapping().asMap().entrySet()) {
            newMappingsBuilder.put((Object)((Symbol)mapping.getKey()), (Object)((Symbol)Iterables.get((Iterable)((Iterable)mapping.getValue()), (int)childIndex)));
        }
    }
}

