/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.RefreshType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.testing.TestingHandle;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestingMetadata
implements ConnectorMetadata {
    public static final Duration STALE_MV_STALENESS = Duration.ofHours(7L);
    private final ConcurrentMap<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
    private final ConcurrentMap<SchemaTableName, ConnectorViewDefinition> views = new ConcurrentHashMap<SchemaTableName, ConnectorViewDefinition>();
    private final ConcurrentMap<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
    private final Set<SchemaTableName> freshMaterializedViews = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<String, RefreshType> queryIdToRefreshType = new ConcurrentHashMap<String, RefreshType>();

    public List<String> listSchemaNames(ConnectorSession session) {
        HashSet<String> schemaNames = new HashSet<String>();
        for (SchemaTableName schemaTableName : this.tables.keySet()) {
            schemaNames.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new TestingTableHandle(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ConnectorTableMetadata tableMetadata = (ConnectorTableMetadata)this.tables.get(tableName);
        Preconditions.checkArgument((tableMetadata != null ? 1 : 0) != 0, (String)"Table '%s' does not exist", (Object)tableName);
        return tableMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TestingColumnHandle(columnMetadata.getName(), index, columnMetadata.getType()));
            ++index;
        }
        return builder.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchema())) {
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : ((ConnectorTableMetadata)this.tables.get(tableName)).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.buildOrThrow();
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        return new ConnectorAnalyzeMetadata(tableHandle, TableStatisticsMetadata.empty());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        int columnIndex = ((TestingColumnHandle)columnHandle).getOrdinalPosition();
        return (ColumnMetadata)((ConnectorTableMetadata)this.tables.get(tableName)).getColumns().get(columnIndex);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tables.keySet()) {
            if (!schemaName.map(tableName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        ConnectorTableMetadata table = this.getTableMetadata(session, tableHandle);
        if (this.tables.putIfAbsent(newTableName, table) != null) {
            throw new IllegalArgumentException("Target table already exists: " + String.valueOf(newTableName));
        }
        this.tables.remove(table.getTable(), table);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        ConnectorTableMetadata existingTable = this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata);
        if (existingTable != null && saveMode == SaveMode.FAIL) {
            throw new IllegalArgumentException("Target table already exists: " + String.valueOf(tableMetadata.getTable()));
        }
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.tables.remove(TestingMetadata.getTableName(tableHandle));
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, Map<String, Object> viewProperties, boolean replace) {
        Preconditions.checkArgument((boolean)viewProperties.isEmpty(), (Object)"This connector does not support creating views with properties");
        if (replace) {
            this.views.put(viewName, definition);
        } else if (this.views.putIfAbsent(viewName, definition) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + String.valueOf(viewName));
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName viewName : this.views.keySet()) {
            if (!schemaName.map(viewName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)viewName);
        }
        return builder.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        return ImmutableMap.copyOf((Map)Maps.filterKeys(this.views, arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)));
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable((ConnectorViewDefinition)this.views.get(viewName));
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        if (replace) {
            this.materializedViews.put(viewName, definition);
        } else if (this.materializedViews.putIfAbsent(viewName, definition) != null) {
            if (ignoreExisting) {
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + String.valueOf(viewName));
        }
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        ConnectorMaterializedViewDefinition materializedView = this.getMaterializedView(session, source).orElseThrow();
        if (this.materializedViews.putIfAbsent(target, materializedView) != null) {
            throw new IllegalArgumentException("Target materialized view already exists: " + String.valueOf(target));
        }
        this.materializedViews.remove(source, materializedView);
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable((ConnectorMaterializedViewDefinition)this.materializedViews.get(viewName));
    }

    public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition materializedViewDefinition) {
        return ImmutableMap.of();
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        if (this.materializedViews.remove(viewName) == null) {
            throw new MaterializedViewNotFoundException(viewName);
        }
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName name) {
        boolean fresh = this.freshMaterializedViews.contains(name);
        return new MaterializedViewFreshness(fresh ? MaterializedViewFreshness.Freshness.FRESH : MaterializedViewFreshness.Freshness.STALE, fresh ? Optional.empty() : Optional.of(Instant.now().minus(STALE_MV_STALENESS)));
    }

    public void markMaterializedViewIsFresh(SchemaTableName name) {
        this.freshMaterializedViews.add(name);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return false;
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode, RefreshType refreshType) {
        this.queryIdToRefreshType.put(session.getQueryId(), refreshType);
        return TestingHandle.INSTANCE;
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        this.createTable(session, tableMetadata, SaveMode.FAIL);
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll((Iterable)tableMetadata.getColumns());
        columns.add((Object)column);
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)columns.build(), tableMetadata.getProperties(), tableMetadata.getComment()));
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Type type) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
        ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, column);
        columns.set(columns.indexOf(columnMetadata), ColumnMetadata.builderFrom((ColumnMetadata)columnMetadata).setType(type).build());
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)ImmutableList.copyOf(columns), tableMetadata.getProperties(), tableMetadata.getComment()));
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, source);
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
        columns.set(columns.indexOf(columnMetadata), ColumnMetadata.builderFrom((ColumnMetadata)columnMetadata).setName(target).build());
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)ImmutableList.copyOf(columns), tableMetadata.getProperties(), tableMetadata.getComment()));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
    }

    public Optional<RefreshType> getRefreshType(String queryId) {
        return Optional.ofNullable((RefreshType)this.queryIdToRefreshType.get(queryId));
    }

    public void clear() {
        this.views.clear();
        this.tables.clear();
        this.queryIdToRefreshType.clear();
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof TestingTableHandle), (Object)"tableHandle is not an instance of TestingTableHandle");
        TestingTableHandle testingTableHandle = (TestingTableHandle)tableHandle;
        return testingTableHandle.getTableName();
    }

    public static class TestingTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName tableName;

        public TestingTableHandle() {
            this(new SchemaTableName("test-schema", "test-table"));
        }

        @JsonCreator
        public TestingTableHandle(@JsonProperty(value="tableName") SchemaTableName schemaTableName) {
            this.tableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public String toString() {
            return this.tableName.toString();
        }
    }

    public static class TestingColumnHandle
    implements ColumnHandle {
        private final String name;
        private final OptionalInt ordinalPosition;
        private final Optional<Type> type;

        public TestingColumnHandle(String name) {
            this(name, OptionalInt.empty(), Optional.empty());
        }

        public TestingColumnHandle(String name, int ordinalPosition, Type type) {
            this(name, OptionalInt.of(ordinalPosition), Optional.of(type));
        }

        @JsonCreator
        public TestingColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") OptionalInt ordinalPosition, @JsonProperty(value="type") Optional<Type> type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.ordinalPosition = Objects.requireNonNull(ordinalPosition, "ordinalPosition is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition.orElseThrow(() -> new UnsupportedOperationException("Testing handle was created without ordinal position"));
        }

        public Type getType() {
            return this.type.orElseThrow(() -> new UnsupportedOperationException("Testing handle was created without type"));
        }

        @JsonProperty(value="ordinalPosition")
        public OptionalInt getJsonOrdinalPosition() {
            return this.ordinalPosition;
        }

        @JsonProperty(value="type")
        public Optional<Type> getJsonType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingColumnHandle that = (TestingColumnHandle)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.ordinalPosition, that.ordinalPosition) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ordinalPosition, this.type);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.ordinalPosition).add("name", (Object)this.name).add("type", this.type).toString();
        }
    }
}

