/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.exchange;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.spi.exchange.ExchangeManagerContext;

import static java.util.Objects.requireNonNull;

public class ExchangeManagerContextInstance
        implements ExchangeManagerContext
{
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    public ExchangeManagerContextInstance(
            OpenTelemetry openTelemetry,
            Tracer tracer)
    {
        this.openTelemetry = requireNonNull(openTelemetry, "openTelemetry is null");
        this.tracer = requireNonNull(tracer, "tracer is null");
    }

    @Override
    public OpenTelemetry getOpenTelemetry()
    {
        return openTelemetry;
    }

    @Override
    public Tracer getTracer()
    {
        return tracer;
    }
}
