/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlockBuilder {
    @Test
    public void testMultipleValuesWithNull() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(10);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        Block block = blockBuilder.build();
        Assertions.assertThat((boolean)block.isNull(0)).isTrue();
        Assertions.assertThat((long)BigintType.BIGINT.getLong(block, 1)).isEqualTo(42L);
        Assertions.assertThat((boolean)block.isNull(2)).isTrue();
        Assertions.assertThat((long)BigintType.BIGINT.getLong(block, 3)).isEqualTo(42L);
    }

    @Test
    public void testNewBlockBuilderLike() {
        ImmutableList channels = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
        PageBuilder pageBuilder = new PageBuilder((List)channels);
        BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder varcharBlockBuilder = pageBuilder.getBlockBuilder(1);
        ArrayBlockBuilder arrayBlockBuilder = (ArrayBlockBuilder)pageBuilder.getBlockBuilder(2);
        int i = 0;
        while (i < 100) {
            int value = i++;
            BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)value);
            VarcharType.VARCHAR.writeSlice(varcharBlockBuilder, Slices.utf8Slice((String)("test" + value)));
            arrayBlockBuilder.buildEntry(elementBuilder -> {
                ArrayBlockBuilder nestedArrayBuilder = (ArrayBlockBuilder)elementBuilder;
                nestedArrayBuilder.buildEntry(valueBuilder -> BigintType.BIGINT.writeLong(valueBuilder, (long)value));
                nestedArrayBuilder.buildEntry(valueBuilder -> BigintType.BIGINT.writeLong(valueBuilder, (long)value * 2L));
            });
            pageBuilder.declarePosition();
        }
        PageBuilder newPageBuilder = pageBuilder.newPageBuilderLike();
        for (int i2 = 0; i2 < channels.size(); ++i2) {
            Assertions.assertThat((Object)pageBuilder.getBlockBuilder(i2)).isNotEqualTo((Object)newPageBuilder.getBlockBuilder(i2));
            Assertions.assertThat((int)newPageBuilder.getBlockBuilder(i2).getPositionCount()).isEqualTo(0);
            Assertions.assertThat((newPageBuilder.getBlockBuilder(i2).getRetainedSizeInBytes() < pageBuilder.getBlockBuilder(i2).getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        }
    }

    @Test
    public void testGetPositions() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 43L);
        blockBuilder.appendNull();
        int[] positions = new int[]{0, 1, 1, 1, 4};
        Block block = blockBuilder.build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, positions.length), TestBlockBuilder.buildBigintBlock(null, 42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 4), TestBlockBuilder.buildBigintBlock(42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 2, 1), TestBlockBuilder.buildBigintBlock(42));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        TestBlockBuilder.assertInvalidPosition(block, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidPosition(block, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, 2, -1);
        AtomicBoolean isIdentical = new AtomicBoolean(false);
        block.getPositions(positions, 0, positions.length - 1).retainedBytesForEachPart((part, size) -> {
            if (part == positions) {
                isIdentical.set(true);
            }
        });
        Assertions.assertThat((boolean)isIdentical.get()).isTrue();
    }

    private static Block buildBigintBlock(Integer ... values) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5);
        for (Integer value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(blockBuilder, (long)value.intValue());
        }
        return blockBuilder.build();
    }

    private static void assertInvalidPosition(Block block, int[] positions, int offset, int length) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BigintType.BIGINT.getLong(block.getPositions(positions, offset, length), 0)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IndexOutOfBoundsException.class})).hasMessage("Invalid position %d and length 1 in block with %d positions", new Object[]{positions[0], block.getPositionCount()});
    }

    private static void assertInvalidOffset(Block block, int[] positions, int offset, int length) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BigintType.BIGINT.getLong(block.getPositions(positions, offset, length), 0)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IndexOutOfBoundsException.class})).hasMessage(String.format("Invalid offset %d and length %d in array with %d elements", offset, length, positions.length));
    }
}

