/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowBlock
extends AbstractTestBlock {
    @Test
    public void testWithVarcharBigint() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] testRows = this.generateTestRows((List<Type>)fieldTypes, 100);
        this.testWith((List<Type>)fieldTypes, testRows);
        this.testWith((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(testRows));
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] expectedValues = TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100));
        Block block = this.createBlockBuilderWithValues((List<Type>)fieldTypes, expectedValues).build();
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = this.getExpectedEstimatedDataSize(expectedValues[i]);
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo((long)expectedSize);
        }
    }

    @Test
    public void testFromFieldBlocksNoNullsDetection() {
        boolean[] rowIsNull = new boolean[5];
        Assertions.assertThat((boolean)RowBlock.fromNotNullSuppressedFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes())}).mayHaveNull()).isTrue();
        rowIsNull[rowIsNull.length - 1] = true;
        Assertions.assertThat((boolean)RowBlock.fromNotNullSuppressedFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{new ByteArrayBlock(5, Optional.of(rowIsNull), TestRowBlock.createExpectedValue(5).getBytes())}).mayHaveNull()).isTrue();
        Assertions.assertThat((boolean)RowBlock.fromNotNullSuppressedFieldBlocks((int)0, Optional.of(new boolean[0]), (Block[])new Block[]{new ByteArrayBlock(0, Optional.empty(), new byte[0])}).mayHaveNull()).isFalse();
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        Block hasNullsBlock = this.createBlockBuilderWithValues((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100))).build();
        Assertions.assertThat((boolean)hasNullsBlock.mayHaveNull()).isTrue();
    }

    private int getExpectedEstimatedDataSize(List<Object> row) {
        if (row == null) {
            return 0;
        }
        int size = 0;
        size += row.get(0) == null ? 0 : ((String)row.get(0)).length();
        return size += row.get(1) == null ? 0 : 8;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        boolean[] rowIsNull = new boolean[]{false, true, false, false, false, false};
        TestRowBlock.assertCompact((Block)RowBlock.fromFieldBlocks((int)0, (Block[])new Block[]{emptyBlock, emptyBlock}));
        TestRowBlock.assertCompact((Block)RowBlock.fromNotNullSuppressedFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{new ByteArrayBlock(6, Optional.of(rowIsNull), TestRowBlock.createExpectedValue(6).getBytes()), new ByteArrayBlock(6, Optional.of(rowIsNull), TestRowBlock.createExpectedValue(6).getBytes())}));
    }

    private void testWith(List<Type> fieldTypes, List<Object>[] expectedValues) {
        Block block = this.createBlockBuilderWithValues(fieldTypes, expectedValues).build();
        this.assertBlock(block, expectedValues);
        IntArrayList positionList = this.generatePositionList(expectedValues.length, expectedValues.length / 2);
        this.assertBlockFilteredPositions(expectedValues, block, positionList.toIntArray());
    }

    private BlockBuilder createBlockBuilderWithValues(List<Type> fieldTypes, List<Object>[] rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (List<Object> row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            rowBlockBuilder.buildEntry(fieldBuilders -> {
                for (int i = 0; i < row.size(); ++i) {
                    Object fieldValue = row.get(i);
                    if (fieldValue == null) {
                        ((BlockBuilder)fieldBuilders.get(i)).appendNull();
                        continue;
                    }
                    if (fieldValue instanceof Long) {
                        BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(i), ((Long)fieldValue).longValue());
                        continue;
                    }
                    if (fieldValue instanceof String) {
                        VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(i), Slices.utf8Slice((String)((String)fieldValue)));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            });
        }
        return rowBlockBuilder;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        RowBlock rowBlock = (RowBlock)block;
        List row = (List)expectedValue;
        Assertions.assertThat((boolean)rowBlock.isNull(position)).isFalse();
        SqlRow sqlRow = rowBlock.getRow(position);
        Assertions.assertThat((int)sqlRow.getFieldCount()).isEqualTo(row.size());
        int rawIndex = sqlRow.getRawIndex();
        for (int i = 0; i < row.size(); ++i) {
            Object fieldValue = row.get(i);
            Block rawFieldBlock = sqlRow.getRawFieldBlock(i);
            if (fieldValue == null) {
                Assertions.assertThat((boolean)rawFieldBlock.isNull(rawIndex)).isTrue();
                continue;
            }
            if (fieldValue instanceof Long) {
                Assertions.assertThat((long)BigintType.BIGINT.getLong(rawFieldBlock, rawIndex)).isEqualTo(((Long)fieldValue).longValue());
                continue;
            }
            if (fieldValue instanceof String) {
                Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(rawFieldBlock, rawIndex)).isEqualTo((Object)Slices.utf8Slice((String)((String)fieldValue)));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
        List[] testRows = new List[numRows];
        for (int i = 0; i < numRows; ++i) {
            ArrayList<Object> testRow = new ArrayList<Object>(fieldTypes.size());
            for (int j = 0; j < fieldTypes.size(); ++j) {
                int cellId = i * fieldTypes.size() + j;
                if (cellId % 7 == 3) {
                    testRow.add(null);
                    continue;
                }
                if (fieldTypes.get(j) == BigintType.BIGINT) {
                    testRow.add((long)i * 100L + (long)j);
                    continue;
                }
                if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                    testRow.add(String.format("field(%s, %s)", i, j));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            testRows[i] = testRow;
        }
        return testRows;
    }

    private IntArrayList generatePositionList(int numRows, int numPositions) {
        IntArrayList positions = new IntArrayList(numPositions);
        for (int i = 0; i < numPositions; ++i) {
            positions.add((7 * i + 3) % numRows);
        }
        Collections.sort(positions);
        return positions;
    }
}

