/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.node.NodeInfo;
import io.trino.connector.CatalogPruneTask;
import io.trino.connector.CatalogPruneTaskConfig;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.execution.SqlTaskManager;
import io.trino.metadata.CatalogManager;
import io.trino.server.InternalCommunicationConfig;
import io.trino.spi.connector.CatalogHandle;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TestingLocalCatalogPruneTask
extends CatalogPruneTask {
    private final SqlTaskManager sqlTaskManagerToPrune;

    public TestingLocalCatalogPruneTask(TransactionManager transactionManager, CatalogManager catalogManager, ConnectorServicesProvider connectorServicesProvider, NodeInfo nodeInfo, CatalogPruneTaskConfig catalogPruneTaskConfig, SqlTaskManager sqlTaskManagerToPrune) {
        super(transactionManager, catalogManager, connectorServicesProvider, nodeInfo, new ServiceSelector(){

            public String getType() {
                throw new UnsupportedOperationException("No services to select");
            }

            public String getPool() {
                throw new UnsupportedOperationException("No pool");
            }

            public List<ServiceDescriptor> selectAllServices() {
                return ImmutableList.of();
            }

            public ListenableFuture<List<ServiceDescriptor>> refresh() {
                return Futures.immediateFuture((Object)ImmutableList.of());
            }
        }, (HttpClient)new TestingHttpClient(request -> {
            throw new UnsupportedOperationException("Testing Locl Catalog Prune Task does not make http calls");
        }), catalogPruneTaskConfig, new InternalCommunicationConfig());
        this.sqlTaskManagerToPrune = Objects.requireNonNull(sqlTaskManagerToPrune, "sqlTaskManagerToPrune is null");
    }

    void pruneWorkerCatalogs(Set<ServiceDescriptor> online, List<CatalogHandle> activeCatalogs) {
        this.sqlTaskManagerToPrune.pruneCatalogs((Set)ImmutableSet.copyOf(activeCatalogs));
    }
}

