/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.RollbackTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Rollback;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRollbackTask {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        Assertions.assertThat((Optional)stateMachine.getSession().getTransactionId()).isPresent();
        Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
        MoreFutures.getFutureValue((Future)new RollbackTask(transactionManager).execute(new Rollback(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isTrue();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    @Test
    public void testNoTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new RollbackTask(transactionManager).execute(new Rollback(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_IN_TRANSACTION});
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isFalse();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    @Test
    public void testUnknownTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(TransactionId.create()).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("ROLLBACK", session, transactionManager);
        MoreFutures.getFutureValue((Future)new RollbackTask(transactionManager).execute(new Rollback(new NodeLocation(1, 1)), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId()).isTrue();
        Assertions.assertThat((Optional)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId()).isEmpty();
        Assertions.assertThat((List)transactionManager.getAllTransactionInfos()).isEmpty();
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin(Optional.empty(), (String)query, Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AllowAllAccessControl(), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

